/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.redis;

import com.github.bingoohuang.utils.redis.RedisConfig;
import com.github.bingoohuang.utils.redis.RedisOp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public class Redis {
    JedisPool pool;

    public Redis(RedisConfig redisConfig) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(redisConfig.getMaxClients());
        this.pool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimeout(), redisConfig.getPassword(), redisConfig.getDatabase());
    }

    public void destroy() {
        this.pool.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object op(RedisOp redisOp) {
        Jedis jedis = this.pool.getResource();
        try {
            Object object = redisOp.exec(jedis);
            return object;
        }
        finally {
            jedis.close();
        }
    }

    public boolean tryLock(String key) {
        boolean tryLock = this.setnx(key, "tryLock");
        if (tryLock) {
            this.expire(key, 10L, TimeUnit.SECONDS);
        }
        return tryLock;
    }

    public boolean isLocked(String key) {
        String s = this.get(key);
        return s != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setnx(String key, String value) {
        Jedis jedis = this.pool.getResource();
        try {
            boolean bl = jedis.setnx(key, value) == 1L;
            return bl;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            Long l = jedis.ttl(key);
            return l;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, String value, long expire, TimeUnit timeUnit) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.setex(key, (int)timeUnit.toSeconds(expire), value);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmsetex(String key, Map value, long expire, TimeUnit timeUnit) {
        Jedis jedis = this.pool.getResource();
        try {
            String result = jedis.hmset(key, value);
            jedis.expire(key, (int)timeUnit.toSeconds(expire));
            String string = result;
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.set(key, value);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incr(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            long l = jedis.incr(key);
            return l;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrBy(String key, long incrBy) {
        Jedis jedis = this.pool.getResource();
        try {
            long l = jedis.incrBy(key, incrBy);
            return l;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map value) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.hmset(key, value);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.hget(key, field);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String ... names) {
        Jedis jedis = this.pool.getResource();
        try {
            Long l = jedis.lpush(key, names);
            return l;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            String string = jedis.lpop(key);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List lrange(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            List list = jedis.lrange(key, 0L, -1L);
            return list;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List lrange(String key, long start, long end) {
        Jedis jedis = this.pool.getResource();
        try {
            List list = jedis.lrange(key, start, end);
            return list;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndDel(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            Transaction multi = jedis.multi();
            multi.get(key);
            multi.del(key);
            List result = multi.exec();
            String string = (String)result.get(0);
            return string;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        Jedis jedis = this.pool.getResource();
        try {
            Long l = jedis.del(key);
            return l;
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(String key, long expireValue, TimeUnit timeUnit) {
        Jedis jedis = this.pool.getResource();
        try {
            jedis.expire(key, (int)timeUnit.toSeconds(expireValue));
        }
        finally {
            jedis.close();
        }
    }
}

