/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.xml;

import com.github.bingoohuang.utils.xml.Xmls;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;

public class PrettyPrintHandler
implements InvocationHandler {
    private final XMLStreamWriter target;
    private final boolean prettyFormat;
    private final boolean withXmlDeclaration;
    private int depth = 0;
    private final Map<Integer, Boolean> hasChildElement = new HashMap<Integer, Boolean>();
    private static final String INDENT_CHAR = "  ";
    private static final String LINEFEED_CHAR = "\n";
    private static final Pattern XML_CHARS = Pattern.compile("[&<>]");

    public PrettyPrintHandler(XMLStreamWriter target, EnumSet<Xmls.MarshalOption> marshalOptions) {
        this.target = target;
        this.prettyFormat = marshalOptions.contains((Object)Xmls.MarshalOption.PrettyFormat);
        this.withXmlDeclaration = marshalOptions.contains((Object)Xmls.MarshalOption.WithXmlDeclaration);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("writeStartDocument".equals(methodName)) {
            if (this.withXmlDeclaration) {
                this.target.writeStartDocument("UTF-8", "1.0");
            }
            return null;
        }
        if ("writeCharacters".equals(methodName) && args[0] instanceof String) {
            String text = (String)args[0];
            boolean useCData = XML_CHARS.matcher(text).find();
            if (useCData) {
                this.target.writeCData(text);
            } else {
                this.target.writeCharacters(text);
            }
            return null;
        }
        if ("writeStartElement".equals(methodName) && this.prettyFormat) {
            if (this.depth > 0) {
                this.hasChildElement.put(this.depth - 1, true);
            }
            this.hasChildElement.put(this.depth, false);
            if (this.depth > 0 || this.withXmlDeclaration) {
                this.target.writeCharacters(LINEFEED_CHAR);
            }
            this.target.writeCharacters(StringUtils.repeat((String)INDENT_CHAR, (int)this.depth));
            ++this.depth;
        } else if ("writeEndElement".equals(methodName) && this.prettyFormat) {
            --this.depth;
            if (this.hasChildElement.get(this.depth).booleanValue()) {
                this.target.writeCharacters(LINEFEED_CHAR);
                this.target.writeCharacters(StringUtils.repeat((String)INDENT_CHAR, (int)this.depth));
            }
        }
        return method.invoke((Object)this.target, args);
    }
}

