/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.xml;

import com.github.bingoohuang.utils.xml.PrettyPrintHandler;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Xmls {
    public static String marshal(Object bean, MarshalOption ... marshalOptions) {
        EnumSet enumSet = Sets.newEnumSet(Arrays.asList(marshalOptions), MarshalOption.class);
        return Xmls.marshal(bean, enumSet, bean.getClass());
    }

    public static String marshal(Object bean, EnumSet<MarshalOption> marshalOptions, Class ... types) {
        StringWriter sw = new StringWriter();
        try {
            JAXBContext carContext = JAXBContext.newInstance((Class[])types);
            Marshaller marshaller = carContext.createMarshaller();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter streamWriter = xof.createXMLStreamWriter(sw);
            PrettyPrintHandler handler = new PrettyPrintHandler(streamWriter, marshalOptions);
            XMLStreamWriter prettyPrintWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
            marshaller.marshal(bean, prettyPrintWriter);
            String xml = sw.toString();
            xml = xml.replaceAll(" xmlns:xsi=\"http://www\\.w3\\.org/2001/XMLSchema-instance\" xsi:nil=\"true\"", "");
            return xml;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> T unmarshal(String xml, Class<T> beanClass) {
        StringReader reader = new StringReader(xml);
        return (T)JAXB.unmarshal((Reader)reader, beanClass);
    }

    public static String prettyXml(String xml) {
        boolean omitXmlDeclaration = !xml.startsWith("<?xml");
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(Xmls.parseXmlFile(xml));
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseXmlFile(String xml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            return db.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum MarshalOption {
        PrettyFormat,
        WithXmlDeclaration;

    }
}

