/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.extractor.CookiesRequestExtractor;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;

public final class CookieRequestExtractor
extends HttpRequestExtractor<String> {
    private final CookiesRequestExtractor extractor = new CookiesRequestExtractor();
    private final String key;

    public CookieRequestExtractor(String key) {
        this.key = key;
    }

    @Override
    protected Optional<String> doExtract(HttpRequest request) {
        Optional cookies = this.extractor.extract(request);
        if (cookies.isPresent()) {
            return Optional.ofNullable(((ImmutableMap)cookies.get()).get((Object)this.key));
        }
        return Optional.empty();
    }
}

