/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class FormsRequestExtractor
extends HttpRequestExtractor<ImmutableMap<String, String>> {
    @Override
    protected Optional<ImmutableMap<String, String>> doExtract(HttpRequest request) {
        HttpPostRequestDecoder decoder = null;
        try {
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
            FullHttpRequest targetRequest = ((DefaultHttpRequest)request).toFullHttpRequest();
            Charset charset = HttpUtil.getCharset((HttpMessage)targetRequest);
            decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, (io.netty.handler.codec.http.HttpRequest)targetRequest, charset);
            Optional<ImmutableMap<String, String>> optional = Optional.of(this.doExtractForms(decoder));
            return optional;
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException idde) {
            Optional<ImmutableMap<String, String>> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
        finally {
            if (decoder != null) {
                decoder.destroy();
            }
        }
    }

    private ImmutableMap<String, String> doExtractForms(HttpPostRequestDecoder decoder) throws IOException {
        List bodyHttpDatas = decoder.getBodyHttpDatas();
        HashMap forms = Maps.newHashMap();
        for (InterfaceHttpData data : bodyHttpDatas) {
            if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            Attribute attribute = (Attribute)data;
            forms.put(attribute.getName(), attribute.getValue());
        }
        return ImmutableMap.copyOf((Map)forms);
    }
}

