/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MutableHttpResponse;
import com.github.dreamhead.moco.MutableResponse;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.handler.HeaderDetector;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.net.MediaType;

public abstract class AbstractContentResponseHandler
extends AbstractResponseHandler {
    private final HeaderDetector detector = new HeaderDetector();

    protected abstract MessageContent responseContent(Request var1);

    protected abstract MediaType getContentType(HttpRequest var1);

    @Override
    public final void writeToResponse(SessionContext context) {
        Request request = context.getRequest();
        Response response = context.getResponse();
        if (HttpRequest.class.isInstance(request) && MutableHttpResponse.class.isInstance(response)) {
            HttpRequest httpRequest = (HttpRequest)HttpRequest.class.cast(request);
            MutableHttpResponse httpResponse = (MutableHttpResponse)MutableHttpResponse.class.cast(response);
            this.doWriteToResponse(httpRequest, httpResponse);
            return;
        }
        MutableResponse mutableResponse = (MutableResponse)MutableResponse.class.cast(response);
        mutableResponse.setContent(this.requireResponseContent(request));
    }

    private void doWriteToResponse(HttpRequest httpRequest, MutableHttpResponse httpResponse) {
        MessageContent content = this.requireResponseContent(httpRequest);
        httpResponse.setContent(content);
        httpResponse.addHeader("Content-Length", content.getContent().length);
        if (!this.detector.hasContentType(httpResponse)) {
            httpResponse.addHeader("Content-Type", this.getContentType(httpRequest));
        }
    }

    private MessageContent requireResponseContent(Request request) {
        MessageContent content = this.responseContent(request);
        if (content == null) {
            throw new IllegalStateException("Message content is expected. Please make sure responseContent method has been implemented correctly");
        }
        return content;
    }
}

