/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler.failover;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.handler.failover.FailoverExecutor;
import com.github.dreamhead.moco.handler.failover.FailoverStrategy;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.Set;

public final class Failover {
    public static final Failover DEFAULT_FAILOVER = new Failover(FailoverExecutor.EMPTY_FAILOVER, FailoverStrategy.FAILOVER, new int[0]);
    private final FailoverExecutor executor;
    private final FailoverStrategy strategy;
    private final Set<Integer> statuses;

    public Failover(FailoverExecutor executor, FailoverStrategy strategy, int ... statuses) {
        this.executor = executor;
        this.strategy = strategy;
        this.statuses = this.asProxyStatuses(statuses);
    }

    private ImmutableSet<Integer> asProxyStatuses(int[] proxyStatuses) {
        if (proxyStatuses.length == 0) {
            return ImmutableSet.of((Object)HttpResponseStatus.BAD_REQUEST.code());
        }
        return ImmutableSet.copyOf((Collection)Ints.asList((int[])proxyStatuses));
    }

    public boolean shouldFailover(org.apache.http.HttpResponse remoteResponse) {
        int statusCode = remoteResponse.getStatusLine().getStatusCode();
        return this.statuses.contains(statusCode);
    }

    public HttpResponse failover(HttpRequest request) {
        return this.executor.failover(request);
    }

    public void onCompleteResponse(HttpRequest request, HttpResponse response) {
        this.executor.onCompleteResponse(request, response);
    }

    public boolean isPlayback() {
        return this.strategy == FailoverStrategy.PLAYBACK;
    }
}

