/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.google.common.collect.Iterables;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class CompositeRequestMatcher
extends AbstractRequestMatcher {
    private final Iterable<RequestMatcher> matchers;

    protected abstract RequestMatcher newMatcher(Iterable<RequestMatcher> var1);

    protected CompositeRequestMatcher(Iterable<RequestMatcher> matchers) {
        this.matchers = matchers;
    }

    private Iterable<RequestMatcher> applyToMatchers(MocoConfig config) {
        Iterable appliedMatchers = StreamSupport.stream(this.matchers.spliterator(), false).map(matcher -> (RequestMatcher)matcher.apply(config)).collect(Collectors.toList());
        if (Iterables.elementsEqual(this.matchers, (Iterable)appliedMatchers)) {
            return this.matchers;
        }
        return appliedMatchers;
    }

    @Override
    public final RequestMatcher doApply(MocoConfig config) {
        Iterable<RequestMatcher> appliedMatchers = this.applyToMatchers(config);
        if (appliedMatchers == this.matchers) {
            return this;
        }
        return this.newMatcher(appliedMatchers);
    }

    @Override
    public final boolean match(Request request) {
        return this.doMatch(request, this.matchers);
    }

    protected abstract boolean doMatch(Request var1, Iterable<RequestMatcher> var2);
}

