/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.github.dreamhead.moco.HttpMessage;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.util.Maps;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultHttpMessage
implements HttpMessage {
    private final HttpProtocolVersion version;
    private final MessageContent content;
    private final ImmutableMap<String, String[]> headers;

    protected DefaultHttpMessage(HttpProtocolVersion version, MessageContent content, ImmutableMap<String, String[]> headers) {
        this.version = version;
        this.content = content;
        this.headers = headers;
    }

    @Override
    public final HttpProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public final ImmutableMap<String, String[]> getHeaders() {
        return this.headers;
    }

    @Override
    public final String getHeader(String name) {
        if (!this.headers.containsKey((Object)name)) {
            return null;
        }
        String[] values = (String[])this.headers.get((Object)name);
        return values[0];
    }

    @Override
    public final MessageContent getContent() {
        return this.content;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("version", (Object)this.version).add("headers", this.headers).add("content", (Object)this.content);
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected static Map<String, Iterable<String>> toHeaders(io.netty.handler.codec.http.HttpMessage message) {
        return DefaultHttpMessage.toHeaders((Iterable<Map.Entry<String, String>>)message.headers());
    }

    private static Map<String, Iterable<String>> toHeaders(Iterable<Map.Entry<String, String>> httpHeaders) {
        HashMap<String, Iterable<String>> headers = new HashMap<String, Iterable<String>>();
        for (Map.Entry<String, String> entry : httpHeaders) {
            String key = entry.getKey();
            List<String> values = DefaultHttpMessage.getValues(headers, key);
            values.add(entry.getValue());
            headers.put(key, values);
        }
        return headers;
    }

    private static List<String> getValues(Map<String, Iterable<String>> headers, String key) {
        if (headers.containsKey(key)) {
            return (List)headers.get(key);
        }
        return new ArrayList<String>();
    }

    protected static abstract class Builder<T extends Builder> {
        private final Class<T> clazz = TypeToken.of(this.getClass()).getRawType();
        private HttpProtocolVersion version;
        private MessageContent content;
        private Map<String, String[]> headers;

        protected Builder() {
        }

        private T self() {
            return (T)((Builder)this.clazz.cast(this));
        }

        public final T withVersion(HttpProtocolVersion version) {
            this.version = version;
            return this.self();
        }

        public final T withStringContent(String content) {
            this.content = MessageContent.content(content);
            return this.self();
        }

        public final T withContent(MessageContent content) {
            this.content = content;
            return this.self();
        }

        public final T withHeaders(Map<String, ?> headers) {
            if (headers != null) {
                this.headers = this.asHeaders(headers);
            }
            return this.self();
        }

        private Map<String, String[]> asHeaders(Map<String, ?> headers) {
            if (headers.isEmpty()) {
                return ImmutableMap.of();
            }
            Object value = ((Map.Entry)Iterables.getFirst(headers.entrySet(), null)).getValue();
            if (value instanceof String) {
                return Maps.simpleValueToArray(headers);
            }
            if (value instanceof String[]) {
                return headers;
            }
            if (value instanceof Iterable) {
                return Maps.iterableValueToArray(headers);
            }
            throw new IllegalArgumentException("Unknown header value type [" + value.getClass() + "]");
        }

        protected final HttpProtocolVersion getVersion() {
            return this.version;
        }

        protected final MessageContent getContent() {
            return this.content;
        }

        protected final ImmutableMap<String, String[]> getHeaders() {
            if (this.headers == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.copyOf(this.headers);
        }
    }
}

