/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MutableHttpResponse;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;

public final class DefaultMutableHttpResponse
implements MutableHttpResponse {
    private HttpProtocolVersion version;
    private Map<String, String[]> headers = Maps.newHashMap();
    private int status;
    private MessageContent content;
    private static final String[] SINGLE_VALUE_HEADERS = new String[]{"Content-Type"};

    private DefaultMutableHttpResponse() {
    }

    @Override
    public void setVersion(HttpProtocolVersion version) {
        this.version = version;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void setContent(MessageContent content) {
        if (this.content != null) {
            throw new IllegalArgumentException("Content has been set");
        }
        this.content = content;
    }

    @Override
    public void addHeader(String name, Object value) {
        if (this.headers.containsKey(name) && this.isSingleValueHeader(name)) {
            this.headers.remove(name);
        }
        this.doAddHeader(name, value);
    }

    private boolean isSingleValueHeader(String name) {
        for (String header : SINGLE_VALUE_HEADERS) {
            if (!header.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void doAddHeader(String name, Object value) {
        this.headers.put(name, this.newValues(name, value));
    }

    private String[] newValues(String name, Object value) {
        if (this.headers.containsKey(name)) {
            String[] values = this.headers.get(name);
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value.toString();
            return newValues;
        }
        return new String[]{value.toString()};
    }

    @Override
    public String getHeader(String name) {
        if (!this.headers.containsKey(name)) {
            return null;
        }
        String[] values = this.headers.get(name);
        return values[0];
    }

    @Override
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public ImmutableMap<String, String[]> getHeaders() {
        return ImmutableMap.copyOf(this.headers);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public MessageContent getContent() {
        return this.content;
    }

    public static DefaultMutableHttpResponse newResponse(HttpRequest request, int status) {
        DefaultMutableHttpResponse httpResponse = new DefaultMutableHttpResponse();
        httpResponse.version = request.getVersion();
        httpResponse.status = status;
        return httpResponse;
    }

    public FullHttpResponse toFullResponse() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.valueOf((String)this.version.text()), HttpResponseStatus.valueOf((int)this.status));
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (String[])entry.getValue()) {
                response.headers().add(key, (Object)value);
            }
        }
        if (this.content != null) {
            response.content().writeBytes(this.content.getContent());
        }
        return response;
    }
}

