/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.recorder.RecorderFactory;
import com.github.dreamhead.moco.recorder.RequestRecorder;
import java.util.HashMap;
import java.util.Map;

public class RecorderRegistry {
    private final RecorderFactory factory;
    private final String groupName;
    private Map<String, RequestRecorder> recorders = new HashMap<String, RequestRecorder>();
    private static final RecorderRegistry REGISTRY = new RecorderRegistry(RecorderFactory.IN_MEMORY, null);
    private static Map<String, RecorderRegistry> registries;

    public RecorderRegistry(RecorderFactory factory, String name) {
        this.factory = factory;
        this.groupName = name;
    }

    public String getGroup() {
        return this.groupName;
    }

    public final RequestRecorder recorderOf(String name) {
        RequestRecorder recorder = this.recorders.get(name);
        if (recorder != null) {
            return recorder;
        }
        return this.recorders.computeIfAbsent(name, s -> this.factory.newRecorder(name));
    }

    public static RecorderRegistry defaultRegistry() {
        return REGISTRY;
    }

    public static RecorderRegistry registryOf(String name, RecorderFactory factory) {
        if (registries == null) {
            registries = new HashMap<String, RecorderRegistry>();
        }
        return registries.computeIfAbsent(name, s -> new RecorderRegistry(factory, name));
    }
}

