/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceConfigApplier;
import com.github.dreamhead.moco.resource.ResourceFactory;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.google.common.collect.ImmutableMap;

public final class ResourceConfigApplierFactory {
    public static final ResourceConfigApplier DO_NOTHING_APPLIER = new ResourceConfigApplier(){

        @Override
        public Resource apply(MocoConfig config, Resource resource) {
            return resource;
        }
    };

    public static ResourceConfigApplier fileConfigApplier(String id, final Resource file) {
        return new SelfResourceConfigApplier(id){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.fileResource(file, null, config);
            }
        };
    }

    public static ResourceConfigApplier cookieConfigApplier(final String key, final Resource cookieResource) {
        return new EmbeddedResourceConfigApplier(cookieResource){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.cookieResource(key, cookieResource.apply(config), new CookieAttribute[0]);
            }
        };
    }

    public static ResourceConfigApplier templateConfigApplier(final ContentResource template, final ImmutableMap<String, ? extends Variable> variables) {
        return new EmbeddedResourceConfigApplier(template){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.templateResource((ContentResource)template.apply(config), (ImmutableMap<String, ? extends Variable>)variables);
            }
        };
    }

    public static ResourceConfigApplier uriConfigApplier(String id, final String uri) {
        return new SelfResourceConfigApplier(id){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.uriResource(config.apply(uri));
            }
        };
    }

    public static ResourceConfigApplier jsonConfigApplier(final Resource resource) {
        return new EmbeddedResourceConfigApplier(resource){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.jsonResource(resource.apply(config));
            }
        };
    }

    private ResourceConfigApplierFactory() {
    }

    private static abstract class EmbeddedResourceConfigApplier
    extends BaseResourceConfigApplier {
        private Resource resource;

        private EmbeddedResourceConfigApplier(Resource resource) {
            this.resource = resource;
        }

        @Override
        protected String id() {
            return this.resource.id();
        }
    }

    private static abstract class SelfResourceConfigApplier
    extends BaseResourceConfigApplier {
        private String id;

        private SelfResourceConfigApplier(String id) {
            this.id = id;
        }

        @Override
        protected String id() {
            return this.id;
        }
    }

    private static abstract class BaseResourceConfigApplier
    implements ResourceConfigApplier {
        private BaseResourceConfigApplier() {
        }

        protected abstract Resource newResource(MocoConfig var1);

        protected abstract String id();

        @Override
        public Resource apply(MocoConfig config, Resource resource) {
            if (config.isFor(this.id())) {
                return this.newResource(config);
            }
            return resource;
        }
    }
}

