/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.IdFactory;
import com.github.dreamhead.moco.resource.Identifiable;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceConfigApplier;
import com.github.dreamhead.moco.resource.ResourceConfigApplierFactory;
import com.github.dreamhead.moco.resource.ResourceReader;
import com.github.dreamhead.moco.resource.reader.ClasspathFileResourceReader;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.resource.reader.FileResourceReader;
import com.github.dreamhead.moco.resource.reader.JsonResourceReader;
import com.github.dreamhead.moco.resource.reader.TemplateResourceReader;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.github.dreamhead.moco.util.Cookies;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;

public final class ResourceFactory {
    public static ContentResource textResource(final String text) {
        return ResourceFactory.contentResource(IdFactory.id("text"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ContentResourceReader(){

            @Override
            public MediaType getContentType(HttpRequest request) {
                return FileContentType.DEFAULT_CONTENT_TYPE_WITH_CHARSET;
            }

            @Override
            public MessageContent readFor(Request request) {
                return MessageContent.content(text);
            }
        });
    }

    public static ContentResource fileResource(Resource filename, Charset charset, MocoConfig config) {
        return ResourceFactory.contentResource(IdFactory.id("file"), ResourceConfigApplierFactory.fileConfigApplier("file", filename), new FileResourceReader(filename, charset, config));
    }

    public static ContentResource classpathFileResource(Resource filename, Charset charset) {
        return ResourceFactory.contentResource(IdFactory.id("pathresource"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ClasspathFileResourceReader(filename, charset));
    }

    public static ContentResource jsonResource(Resource resource) {
        return ResourceFactory.contentResource(IdFactory.id("json"), ResourceConfigApplierFactory.jsonConfigApplier(resource), resource.reader(ContentResourceReader.class));
    }

    public static ContentResource jsonResource(Object pojo) {
        return ResourceFactory.contentResource(IdFactory.id("json"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new JsonResourceReader(pojo));
    }

    public static Resource methodResource(final String method) {
        return ResourceFactory.resource(IdFactory.id("method"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ResourceReader(){

            @Override
            public MessageContent readFor(Request request) {
                return MessageContent.content(method.toUpperCase());
            }
        });
    }

    public static Resource versionResource(final Resource version) {
        return ResourceFactory.resource(IdFactory.id("version"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ResourceReader(){

            @Override
            public MessageContent readFor(Request request) {
                String text = HttpProtocolVersion.versionOf(version.readFor(request).toString()).text();
                return MessageContent.content(text);
            }
        });
    }

    public static Resource versionResource(final HttpProtocolVersion version) {
        return ResourceFactory.resource(IdFactory.id("version"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ResourceReader(){

            @Override
            public MessageContent readFor(Request request) {
                return MessageContent.content(version.text());
            }
        });
    }

    public static Resource cookieResource(final String key, final Resource resource, final CookieAttribute ... options) {
        return ResourceFactory.resource(IdFactory.id("cookie"), ResourceConfigApplierFactory.cookieConfigApplier(key, resource), new ResourceReader(){

            @Override
            public MessageContent readFor(Request request) {
                MessageContent messageContent = resource.readFor(request);
                return MessageContent.content(new Cookies().encodeCookie(key, messageContent.toString(), options));
            }
        });
    }

    public static ContentResource templateResource(ContentResource template, ImmutableMap<String, ? extends Variable> variables) {
        return ResourceFactory.contentResource(IdFactory.id("template"), ResourceConfigApplierFactory.templateConfigApplier(template, variables), new TemplateResourceReader(template, variables));
    }

    public static Resource uriResource(final String uri) {
        return ResourceFactory.resource(IdFactory.id("uri"), ResourceConfigApplierFactory.uriConfigApplier("uri", uri), new ResourceReader(){

            @Override
            public MessageContent readFor(Request request) {
                return MessageContent.content(uri);
            }
        });
    }

    private static ContentResource contentResource(Identifiable id, ResourceConfigApplier applier, ContentResourceReader reader) {
        return new ContentResource(id, applier, reader);
    }

    private static Resource resource(Identifiable id, ResourceConfigApplier applier, ResourceReader reader) {
        return new Resource(id, applier, reader);
    }

    private ResourceFactory() {
    }
}

