/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.rest.RestIdMatchers;
import com.github.dreamhead.moco.util.URLs;
import java.util.Optional;

public final class SubResourceSetting
implements RestSetting {
    private final RestIdMatcher id;
    private final String name;
    private final Iterable<RestSetting> settings;

    public SubResourceSetting(RestIdMatcher id, String name, Iterable<RestSetting> settings) {
        this.id = id;
        this.name = name;
        this.settings = settings;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public Optional<ResponseHandler> getMatched(RestIdMatcher resourceName, HttpRequest httpRequest) {
        for (RestSetting setting : this.settings) {
            RestIdMatcher idMatcher = RestIdMatchers.match(URLs.join(resourceName.resourceUri(), this.id.resourceUri(), this.name));
            Optional<ResponseHandler> responseHandler = setting.getMatched(idMatcher, httpRequest);
            if (!responseHandler.isPresent()) continue;
            return responseHandler;
        }
        return Optional.empty();
    }
}

