/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.github.dreamhead.moco.util.Preconditions;
import java.io.File;

public final class Files {
    public static String join(String path1, String path2, String ... paths) {
        String finalPath = Files.actualJoin(path1, path2);
        for (String path : paths) {
            finalPath = Files.actualJoin(finalPath, path);
        }
        return finalPath;
    }

    private static String actualJoin(String path1, String path2) {
        return Files.joinFiles(path1, path2).getPath();
    }

    private static File joinFiles(String path1, String path2) {
        Preconditions.checkNotNullOrEmpty(path2, "Empty path is not allowed");
        if (path1 == null) {
            return new File(path2);
        }
        return new File(new File(path1), path2);
    }

    public static File directoryOf(File file) {
        com.google.common.base.Preconditions.checkNotNull((Object)file);
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return new File(".");
        }
        return parentFile;
    }

    private Files() {
    }
}

