/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.dreamhead.moco.MocoException;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jsons {
    private static Logger logger = LoggerFactory.getLogger(Jsons.class);
    private static final TypeFactory DEFAULT_FACTORY = TypeFactory.defaultInstance();
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    public static String toJson(Object value) {
        try {
            return DEFAULT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new MocoException(e);
        }
    }

    public static String toJson(Map map) {
        try {
            return DEFAULT_MAPPER.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            throw new MocoException(e);
        }
    }

    public static <T> T toObject(String value, Class<T> clazz) {
        try {
            return (T)DEFAULT_MAPPER.readValue(value, clazz);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public static <T> T toObject(InputStream value, Class<T> clazz) {
        try {
            return (T)DEFAULT_MAPPER.readValue(value, clazz);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public static <T> T toObject(Reader value, Class<T> clazz) {
        try {
            return (T)DEFAULT_MAPPER.readValue(value, clazz);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public static <T> ImmutableList<T> toObjects(String value, Class<T> elementClass) {
        return Jsons.toObjects(new ByteArrayInputStream(value.getBytes()), elementClass);
    }

    public static <T> ImmutableList<T> toObjects(InputStream stream, Class<T> elementClass) {
        return Jsons.toObjects((ImmutableList<InputStream>)ImmutableList.of((Object)stream), elementClass);
    }

    public static <T> ImmutableList<T> toObjects(ImmutableList<InputStream> streams, Class<T> elementClass) {
        CollectionType type = DEFAULT_FACTORY.constructCollectionType(List.class, elementClass);
        return (ImmutableList)streams.stream().flatMap(Jsons.toObject(type)).collect(ImmutableList.toImmutableList());
    }

    private static <T> Function<InputStream, Stream<T>> toObject(CollectionType type) {
        return input -> {
            try (InputStream actual = input;){
                String text = CharStreams.toString((Readable)new InputStreamReader(actual));
                Stream stream = ((List)DEFAULT_MAPPER.readValue(text, (JavaType)type)).stream();
                return stream;
            }
            catch (UnrecognizedPropertyException e) {
                logger.info("Unrecognized field: {}", (Object)e.getMessage());
                throw new MocoException(String.format("Unrecognized field [ %s ], please check!", e.getPropertyName()));
            }
            catch (JsonMappingException e) {
                logger.info("{} {}", (Object)e.getMessage(), (Object)e.getPathReference());
                throw new MocoException(e);
            }
            catch (IOException e) {
                throw new MocoException(e);
            }
        };
    }

    private Jsons() {
    }
}

