/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.util.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.function.Function;

public final class URLs {
    public static final String SEPARATOR = "/";

    public static String resourceRoot(String name) {
        if (name.startsWith(SEPARATOR)) {
            return name;
        }
        return SEPARATOR + name;
    }

    public static String toBase(String baseUri) {
        if (baseUri.endsWith(SEPARATOR)) {
            return baseUri;
        }
        return baseUri + SEPARATOR;
    }

    public static String join(String base, String ... paths) {
        String target = base;
        for (String path : paths) {
            target = URLs.doJoin(target, path);
        }
        return target;
    }

    private static String doJoin(String base, String path) {
        String joinPath = URLs.toJoinPath(path);
        if (base.endsWith(SEPARATOR)) {
            return base + joinPath;
        }
        if (joinPath.isEmpty()) {
            return base;
        }
        return base + SEPARATOR + joinPath;
    }

    private static String toJoinPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return "";
        }
        if (path.startsWith(SEPARATOR)) {
            return path.substring(1);
        }
        return path;
    }

    public static URL toUrl(String url) {
        try {
            return new URL(Preconditions.checkNotNullOrEmpty(url, "URL should not be null"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Function<HttpRequest, URL> toUrlFunction(Resource url) {
        return input -> URLs.toUrl(url.readFor((Request)input).toString());
    }

    private URLs() {
    }

    public static boolean isValidUrl(String url) {
        try {
            String encodedURL = URLEncoder.encode(url, Charset.defaultCharset().name());
            return url.equals(encodedURL);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }
}

