/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.bootstrap;

import com.github.dreamhead.moco.bootstrap.BootstrapTask;
import com.github.dreamhead.moco.bootstrap.ParseArgException;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.bootstrap.tasks.ShutdownTask;
import com.github.dreamhead.moco.bootstrap.tasks.StartTask;
import com.github.dreamhead.moco.bootstrap.tasks.VersionTask;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
implements BootstrapTask {
    private static Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    private static final String DEFAULT_SHUTDOWN_KEY = "_SHUTDOWN_MOCO_KEY";
    private final ImmutableMap<String, BootstrapTask> tasks = ImmutableMap.builder().put((Object)"start", (Object)StartTask.http("_SHUTDOWN_MOCO_KEY")).put((Object)"shutdown", (Object)new ShutdownTask("_SHUTDOWN_MOCO_KEY")).put((Object)"http", (Object)StartTask.http("_SHUTDOWN_MOCO_KEY")).put((Object)"https", (Object)StartTask.https("_SHUTDOWN_MOCO_KEY")).put((Object)"socket", (Object)StartTask.socket("_SHUTDOWN_MOCO_KEY")).put((Object)"version", (Object)new VersionTask()).build();

    @Override
    public final void run(String[] args) {
        try {
            if (args.length < 1) {
                throw new ParseArgException("task name needs to be specified");
            }
            BootstrapTask task = (BootstrapTask)this.tasks.get((Object)args[0]);
            if (task == null) {
                throw new ParseArgException("unknown task");
            }
            task.run(args);
        }
        catch (ParseArgException e) {
            this.help();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void help() {
        System.out.println(StartArgs.help());
    }
}

