/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.bootstrap.tasks;

import com.github.dreamhead.moco.bootstrap.BootstrapTask;
import com.github.dreamhead.moco.bootstrap.ShutdownArgs;
import com.github.dreamhead.moco.internal.MocoClient;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownTask
implements BootstrapTask {
    private static Logger logger = LoggerFactory.getLogger(ShutdownTask.class);
    private final MocoClient client = new MocoClient();
    private final String shutdownKey;

    public ShutdownTask(String shutdownKey) {
        this.shutdownKey = shutdownKey;
    }

    @Override
    public void run(String[] args) {
        ShutdownArgs shutdownArgs = ShutdownArgs.parse(args);
        this.client.run("127.0.0.1", shutdownArgs.getShutdownPort().get().intValue(), (ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
                pipeline.addLast("handler", (ChannelHandler)new ShutdownHandler());
            }
        });
    }

    private class ShutdownHandler
    extends ChannelInboundHandlerAdapter {
        private ShutdownHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.writeAndFlush((Object)(ShutdownTask.this.shutdownKey + "\r\n")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.close();
            if (ConnectException.class.isInstance(cause)) {
                logger.error("fail to shutdown, please specify correct shutdown port.");
                return;
            }
            throw new RuntimeException(cause);
        }
    }
}

