/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.parser.model.RequestSetting;
import com.github.dreamhead.moco.parser.model.ResponseSetting;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Optional;

public final class RunnerSetting {
    private final ImmutableList<InputStream> streams;
    private final RequestSetting request;
    private final ResponseSetting response;
    private final String context;
    private final String fileRoot;

    private RunnerSetting(ImmutableList<InputStream> streams, String context, String fileRoot, RequestSetting requestSetting, ResponseSetting response) {
        this.streams = streams;
        this.request = requestSetting;
        this.response = response;
        this.context = context;
        this.fileRoot = fileRoot;
    }

    public ImmutableList<InputStream> getStreams() {
        return this.streams;
    }

    public Optional<MocoConfig> context() {
        if (this.context != null) {
            return Optional.of(Moco.context((String)this.context));
        }
        return Optional.empty();
    }

    public Optional<MocoConfig> fileRoot() {
        if (this.fileRoot != null) {
            return Optional.of(Moco.fileRoot((String)this.fileRoot));
        }
        return Optional.empty();
    }

    public Optional<MocoConfig> request() {
        if (this.request != null) {
            return Optional.of(Moco.request((RequestMatcher)this.request.getRequestMatcher()));
        }
        return Optional.empty();
    }

    public Optional<MocoConfig> response() {
        if (this.response != null) {
            return Optional.of(Moco.response((ResponseHandler)this.response.getResponseHandler()));
        }
        return Optional.empty();
    }

    public static Builder aRunnerSetting() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<InputStream> streams = ImmutableList.builder();
        private RequestSetting request;
        private ResponseSetting response;
        private String context;
        private String fileRoot;

        public final Builder addStream(InputStream stream) {
            this.streams.add((Object)stream);
            return this;
        }

        public final Builder addStreams(ImmutableList<InputStream> streams) {
            this.streams.addAll(streams);
            return this;
        }

        public final Builder withRequest(RequestSetting request) {
            this.request = request;
            return this;
        }

        public final Builder withResponse(ResponseSetting response) {
            this.response = response;
            return this;
        }

        public final Builder withContext(String context) {
            this.context = context;
            return this;
        }

        public final Builder withFileRoot(String fileRoot) {
            this.fileRoot = fileRoot;
            return this;
        }

        public final RunnerSetting build() {
            return new RunnerSetting(this.streams.build(), this.context, this.fileRoot, this.request, this.response);
        }
    }
}

