/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.github.ferstl.maven.pomenforcers.model.ArtifactModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyScope;
import com.github.ferstl.maven.pomenforcers.model.DependencyScopeAdapter;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="dependency")
public class DependencyModel
extends ArtifactModel {
    private static final Joiner TO_STRING_JOINER = Joiner.on((String)":").skipNulls();
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    @XmlJavaTypeAdapter(value=DependencyScopeAdapter.class)
    private DependencyScope scope;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String classifier;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String type;
    @XmlElementWrapper(namespace="http://maven.apache.org/POM/4.0.0")
    @XmlElement(name="exclusion", namespace="http://maven.apache.org/POM/4.0.0")
    private List<ArtifactModel> exclusions;

    DependencyModel() {
    }

    public DependencyModel(String groupId, String artifactId, String version, String scope, String classifier, String type) {
        super(groupId, artifactId, version);
        this.scope = scope != null ? DependencyScope.getByScopeName(scope) : null;
        this.classifier = classifier;
        this.type = type;
    }

    public DependencyScope getScope() {
        return this.scope != null ? this.scope : DependencyScope.COMPILE;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type != null ? this.type : "jar";
    }

    public List<ArtifactModel> getExclusions() {
        return this.exclusions != null ? this.exclusions : Collections.emptyList();
    }

    @Override
    public String toString() {
        return TO_STRING_JOINER.join((Object)super.toString(), (Object)this.getType(), new Object[]{this.getScope().getScopeName(), this.classifier});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DependencyModel)) {
            return false;
        }
        DependencyModel other = (DependencyModel)obj;
        return super.equals(other) && com.google.common.base.Objects.equal((Object)this.classifier, (Object)other.classifier) && com.google.common.base.Objects.equal((Object)this.type, (Object)other.type) && com.google.common.base.Objects.equal((Object)((Object)this.scope), (Object)((Object)other.scope)) && com.google.common.base.Objects.equal(this.exclusions, other.exclusions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.classifier, this.type, this.scope});
    }
}

