/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model.functions;

import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyScope;
import com.github.ferstl.maven.pomenforcers.model.functions.AbstractOneToOneMatcher;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.google.common.collect.ImmutableBiMap;
import java.util.Objects;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;

public class DependencyMatcher
extends AbstractOneToOneMatcher<Dependency, DependencyModel> {
    public DependencyMatcher(EnforcerRuleHelper helper) {
        super(helper);
    }

    @Override
    protected DependencyModel transform(Dependency mavenDependency) {
        return new DependencyModel(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), mavenDependency.getScope(), mavenDependency.getClassifier(), mavenDependency.getType());
    }

    @Override
    protected boolean matches(DependencyModel supersetItem, DependencyModel subsetItem) {
        String groupId = EnforcerRuleUtils.evaluateProperties(subsetItem.getGroupId(), this.getHelper());
        String artifactId = EnforcerRuleUtils.evaluateProperties(subsetItem.getArtifactId(), this.getHelper());
        String classifier = EnforcerRuleUtils.evaluateProperties(subsetItem.getClassifier(), this.getHelper());
        String type = EnforcerRuleUtils.evaluateProperties(subsetItem.getType(), this.getHelper());
        return Objects.equals(supersetItem.getGroupId(), groupId) && Objects.equals(supersetItem.getArtifactId(), artifactId) && Objects.equals(supersetItem.getClassifier(), classifier) && Objects.equals(supersetItem.getType(), type);
    }

    @Override
    protected void handleUnmatchedItem(ImmutableBiMap.Builder<DependencyModel, DependencyModel> mapBuilder, DependencyModel subsetItem) {
        String type = EnforcerRuleUtils.evaluateProperties(subsetItem.getType(), this.getHelper());
        if ("pom".equals(type) && DependencyScope.IMPORT.equals((Object)subsetItem.getScope())) {
            mapBuilder.put((Object)subsetItem, (Object)subsetItem);
        } else {
            super.handleUnmatchedItem(mapBuilder, subsetItem);
        }
    }
}

