/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JacksonUtils;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public final class JsonLoader {
    private static final ObjectReader READER = JacksonUtils.getReader();

    private JsonLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromResource(String resource) throws IOException {
        JsonNode ret;
        URL url = JsonLoader.class.getResource(resource);
        if (url == null) {
            throw new IOException("resource " + resource + " not found");
        }
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)url.openStream());
            ret = READER.readTree(in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    public static JsonNode fromURL(URL url) throws IOException {
        return READER.readTree(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromPath(String path) throws IOException {
        JsonNode ret;
        Closer closer = Closer.create();
        try {
            FileInputStream in = (FileInputStream)closer.register((Closeable)new FileInputStream(path));
            ret = READER.readTree((InputStream)in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromFile(File file) throws IOException {
        JsonNode ret;
        Closer closer = Closer.create();
        try {
            FileInputStream in = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
            ret = READER.readTree((InputStream)in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader) throws IOException {
        return READER.readTree(reader);
    }

    public static JsonNode fromString(String json) throws IOException {
        return JsonLoader.fromReader(new StringReader(json));
    }
}

