/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.exception.NoDefaultValueException;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public interface IDataType<CK, JDBC> {
    public String name();

    default public String[] getAliases() {
        return new String[0];
    }

    default public CK defaultValue() {
        throw new NoDefaultValueException("Column[" + this.name() + "] doesn't has default value");
    }

    public Class<CK> javaType();

    @Deprecated
    public int sqlTypeId();

    @Deprecated
    default public Class<JDBC> jdbcJavaType() {
        return this.javaType();
    }

    default public boolean nullable() {
        return false;
    }

    default public boolean isSigned() {
        return false;
    }

    public int getPrecision();

    public int getScale();

    default public String serializeText(CK value) {
        return value.toString();
    }

    public void serializeBinary(CK var1, BinarySerializer var2) throws SQLException, IOException;

    default public void serializeBinaryBulk(CK[] data, BinarySerializer serializer) throws SQLException, IOException {
        for (CK d : data) {
            this.serializeBinary(d, serializer);
        }
    }

    public CK deserializeText(SQLLexer var1) throws SQLException;

    public CK deserializeBinary(BinaryDeserializer var1) throws SQLException, IOException;

    default public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] data = new Object[rows];
        for (int row = 0; row < rows; ++row) {
            data[row] = this.deserializeBinary(deserializer);
        }
        return data;
    }
}

