/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type;

import com.github.housepower.data.IDataType;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeFloat64
implements IDataType<Double, Double> {
    @Override
    public String name() {
        return "Float64";
    }

    @Override
    public int sqlTypeId() {
        return 8;
    }

    @Override
    public Double defaultValue() {
        return 0.0;
    }

    @Override
    public Class<Double> javaType() {
        return Double.class;
    }

    @Override
    public int getPrecision() {
        return 17;
    }

    @Override
    public int getScale() {
        return 17;
    }

    @Override
    public void serializeBinary(Double data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeDouble(data);
    }

    @Override
    public Double deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return deserializer.readDouble();
    }

    @Override
    public String[] getAliases() {
        return new String[]{"DOUBLE"};
    }

    @Override
    public Double deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().doubleValue();
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

