/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.bean.xmlmessage;

import java.util.ArrayList;
import java.util.List;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.NewsMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

public class XMLNewsMessage
extends XMLMessage {
    private List<Article> articles;

    public XMLNewsMessage(String toUserName, String fromUserName, List<Article> articles) {
        super(toUserName, fromUserName, "news");
        this.articles = articles;
    }

    @Override
    public String subXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ArticleCount>" + this.articles.size() + "</ArticleCount>");
        sb.append("<Articles>");
        for (Article a : this.articles) {
            sb.append("<item>");
            sb.append("<Title><![CDATA[" + (a.title == null ? "" : a.title) + "]]></Title>");
            sb.append("<Description><![CDATA[" + (a.description == null ? "" : a.description) + "]]></Description>");
            sb.append("<PicUrl><![CDATA[" + (a.picurl == null ? "" : a.picurl) + "]]></PicUrl>");
            sb.append("<Url><![CDATA[" + (a.url == null ? "" : a.url) + "]]></Url>");
            sb.append("</item>");
        }
        sb.append("</Articles>");
        return sb.toString();
    }

    @Override
    public Message convert() {
        ArrayList<NewsMessage.Article> list = new ArrayList<NewsMessage.Article>();
        if (this.articles != null) {
            for (Article a : this.articles) {
                NewsMessage.Article item = new NewsMessage.Article(a.getTitle(), a.getDescription(), a.getUrl(), a.getPicurl());
                list.add(item);
            }
        }
        return new NewsMessage(this.toUserName, list);
    }

    public static class Article {
        private String title;
        private String description;
        private String url;
        private String picurl;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPicurl() {
            return this.picurl;
        }

        public void setPicurl(String picurl) {
            this.picurl = picurl;
        }
    }
}

