/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.proxy.ProxyHandler;

public class TunnelProxyInitializer
extends ChannelInitializer {
    private Channel clientChannel;
    private ProxyHandler proxyHandler;

    public TunnelProxyInitializer(Channel clientChannel, ProxyHandler proxyHandler) {
        this.clientChannel = clientChannel;
        this.proxyHandler = proxyHandler;
    }

    protected void initChannel(Channel ch) throws Exception {
        if (this.proxyHandler != null) {
            ch.pipeline().addLast(new ChannelHandler[]{this.proxyHandler});
        }
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx0, Object msg0) throws Exception {
                TunnelProxyInitializer.this.clientChannel.writeAndFlush(msg0);
            }

            public void channelUnregistered(ChannelHandlerContext ctx0) throws Exception {
                ctx0.channel().close();
                TunnelProxyInitializer.this.clientChannel.close();
            }

            public void exceptionCaught(ChannelHandlerContext ctx0, Throwable cause) throws Exception {
                ctx0.channel().close();
                TunnelProxyInitializer.this.clientChannel.close();
                HttpProxyExceptionHandle exceptionHandle = ((HttpProxyServerHandler)TunnelProxyInitializer.this.clientChannel.pipeline().get("serverHandle")).getExceptionHandle();
                exceptionHandle.afterCatch(TunnelProxyInitializer.this.clientChannel, ctx0.channel(), cause);
            }
        }});
    }
}

