/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.intercept.common;

import com.github.monkeywie.proxyee.crt.CertUtil;
import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import com.github.monkeywie.proxyee.server.HttpProxyCACertFactory;
import com.github.monkeywie.proxyee.util.ProtoUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;

public class CertDownIntercept
extends HttpProxyIntercept {
    private boolean crtFlag = false;
    private X509Certificate cert = null;

    public CertDownIntercept() {
    }

    public CertDownIntercept(HttpProxyCACertFactory certFactory) throws Exception {
        this.cert = certFactory.getCACert();
    }

    public CertDownIntercept(X509Certificate caCert) {
        this.cert = caCert;
    }

    @Override
    public void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
        ProtoUtil.RequestProto requestProto = ProtoUtil.getRequestProto(httpRequest);
        if (requestProto == null) {
            clientChannel.close();
            return;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)clientChannel.localAddress();
        if (requestProto.getHost().equals(inetSocketAddress.getHostString()) && requestProto.getPort() == inetSocketAddress.getPort()) {
            this.crtFlag = true;
            if (httpRequest.uri().matches("^.*/ca.crt.*$")) {
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                byte[] bts = this.cert == null ? CertUtil.loadCert(Thread.currentThread().getContextClassLoader().getResourceAsStream("ca.crt")).getEncoded() : this.cert.getEncoded();
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-x509-ca-cert");
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bts.length);
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                DefaultLastHttpContent httpContent = new DefaultLastHttpContent();
                httpContent.content().writeBytes(bts);
                clientChannel.writeAndFlush((Object)httpResponse);
                clientChannel.writeAndFlush((Object)httpContent);
                clientChannel.close();
            } else if (httpRequest.uri().matches("^.*/favicon.ico$")) {
                clientChannel.close();
            } else {
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                String html = "<html><body><div style=\"margin-top:100px;text-align:center;\"><a href=\"ca.crt\">ProxyeeRoot ca.crt</a></div></body></html>";
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=utf-8");
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)html.getBytes().length);
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                DefaultLastHttpContent httpContent = new DefaultLastHttpContent();
                httpContent.content().writeBytes(html.getBytes());
                clientChannel.writeAndFlush((Object)httpResponse);
                clientChannel.writeAndFlush((Object)httpContent);
            }
        } else {
            pipeline.beforeRequest(clientChannel, httpRequest);
        }
    }

    @Override
    public void beforeRequest(Channel clientChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (!this.crtFlag) {
            pipeline.beforeRequest(clientChannel, httpContent);
        }
    }
}

