/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.intercept.common;

import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.ReferenceCountUtil;

public abstract class FullResponseIntercept
extends HttpProxyIntercept {
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 0x800000;
    private int maxContentLength;
    private Boolean isMatch;

    public FullResponseIntercept() {
        this(0x800000);
    }

    public FullResponseIntercept(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public final void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (httpResponse instanceof FullHttpResponse) {
            boolean isAfterMatch;
            FullHttpResponse fullHttpResponse = (FullHttpResponse)httpResponse;
            boolean isFirstMatch = this.isMatch != null && this.isMatch == true;
            boolean bl = isAfterMatch = isFirstMatch ? false : this.matchHandle(pipeline.getHttpRequest(), pipeline.getHttpResponse(), pipeline);
            if (isFirstMatch || isAfterMatch) {
                this.handleResponse(pipeline.getHttpRequest(), fullHttpResponse, pipeline);
                if (fullHttpResponse.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                    httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpResponse.content().readableBytes());
                }
            }
            if (isFirstMatch) {
                proxyChannel.pipeline().remove("decompress");
                proxyChannel.pipeline().remove("aggregator");
            }
        } else {
            this.isMatch = this.matchHandle(pipeline.getHttpRequest(), pipeline.getHttpResponse(), pipeline);
            if (this.isMatch.booleanValue()) {
                proxyChannel.pipeline().addAfter("httpCodec", "decompress", (ChannelHandler)new HttpContentDecompressor());
                proxyChannel.pipeline().addAfter("decompress", "aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
                proxyChannel.pipeline().fireChannelRead((Object)httpResponse);
                return;
            }
        }
        pipeline.afterResponse(clientChannel, proxyChannel, httpResponse);
    }

    @Deprecated
    protected boolean isHtml(HttpRequest httpRequest, HttpResponse httpResponse) {
        String accept = httpRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        String contentType = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return httpResponse.status().code() == 200 && accept != null && accept.matches("^.*text/html.*$") && contentType != null && contentType.matches("^text/html.*$");
    }

    private boolean matchHandle(HttpRequest httpRequest, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) {
        FullHttpRequest fullHttpRequest;
        boolean isMatch = this.match(httpRequest, httpResponse, pipeline);
        if (httpRequest instanceof FullHttpRequest && (fullHttpRequest = (FullHttpRequest)httpRequest).content().refCnt() > 0) {
            ReferenceCountUtil.release((Object)fullHttpRequest);
        }
        return isMatch;
    }

    public abstract boolean match(HttpRequest var1, HttpResponse var2, HttpProxyInterceptPipeline var3);

    public void handleResponse(HttpRequest httpRequest, FullHttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) {
    }
}

