/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;

public class HttpUtil {
    public static boolean checkUrl(HttpRequest httpRequest, String regex) {
        String host = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (host != null && regex != null) {
            String url = httpRequest.uri().indexOf("/") == 0 ? (httpRequest.uri().length() > 1 ? host + httpRequest.uri() : host) : httpRequest.uri();
            return url.matches(regex);
        }
        return false;
    }

    public static boolean checkHeader(HttpHeaders httpHeaders, AsciiString name, String regex) {
        String s = httpHeaders.get((CharSequence)name);
        return s != null && s.matches(regex);
    }

    public static boolean isHtml(HttpRequest httpRequest, HttpResponse httpResponse) {
        String accept = httpRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        String contentType = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return httpResponse.status().code() == 200 && accept != null && accept.matches("^.*text/html.*$") && contentType != null && contentType.matches("^text/html.*$");
    }
}

