/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiReturn;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import java.util.ArrayList;

public class DocClassUtil {
    public static String[] getSimpleGicName(String returnType) {
        if (returnType.contains("<")) {
            String pre = returnType.substring(0, returnType.indexOf("<"));
            if (JavaClassValidateUtil.isMap(pre)) {
                return DocClassUtil.getMapKeyValueType(returnType);
            }
            String type = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
            if (JavaClassValidateUtil.isCollection(pre)) {
                return type.split(" ");
            }
            String[] arr = type.split(",");
            return DocClassUtil.classNameFix(arr);
        }
        return returnType.split(" ");
    }

    public static String getSimpleName(String gicName) {
        if (gicName.contains("<")) {
            return gicName.substring(0, gicName.indexOf("<"));
        }
        return gicName;
    }

    private static String[] classNameFix(String[] arr) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int globIndex = 0;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (classes.size() > 0) {
                int index = classes.size() - 1;
                if (!DocUtil.isClassName((String)classes.get(index))) {
                    if (++globIndex >= length) continue;
                    indexList.add(globIndex);
                    String className = (String)classes.get(index) + "," + arr[globIndex];
                    classes.set(index, className);
                    continue;
                }
                if (++globIndex >= length) continue;
                if (DocUtil.isClassName(arr[globIndex])) {
                    indexList.add(globIndex);
                    classes.add(arr[globIndex]);
                    continue;
                }
                if (indexList.contains(globIndex) || indexList.contains(globIndex + 1)) continue;
                indexList.add(globIndex);
                classes.add(arr[globIndex] + "," + arr[globIndex + 1]);
                indexList.add(++globIndex);
                continue;
            }
            if (DocUtil.isClassName(arr[i])) {
                indexList.add(i);
                classes.add(arr[i]);
                continue;
            }
            if (indexList.contains(i) || indexList.contains(i + 1)) continue;
            globIndex = i + 1;
            classes.add(arr[i] + "," + arr[globIndex]);
            indexList.add(i);
            indexList.add(i + 1);
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getMapKeyValueType(String gName) {
        if (gName.contains("<")) {
            String[] arr = new String[2];
            String key = gName.substring(gName.indexOf("<") + 1, gName.indexOf(","));
            String value = gName.substring(gName.indexOf(",") + 1, gName.lastIndexOf(">"));
            arr[0] = key;
            arr[1] = value;
            return arr;
        }
        return new String[0];
    }

    public static String processTypeNameForParams(String javaTypeName) {
        if (StringUtil.isEmpty((String)javaTypeName)) {
            return "object";
        }
        if (javaTypeName.length() == 1) {
            return "object";
        }
        if (javaTypeName.contains("[]")) {
            return "array";
        }
        switch (javaTypeName) {
            case "java.lang.String": {
                return "string";
            }
            case "string": {
                return "string";
            }
            case "char": {
                return "string";
            }
            case "java.util.List": {
                return "array";
            }
            case "list": {
                return "array";
            }
            case "java.lang.Integer": {
                return "int32";
            }
            case "integer": {
                return "int32";
            }
            case "int": {
                return "int32";
            }
            case "short": {
                return "int16";
            }
            case "java.lang.Short": {
                return "int16";
            }
            case "double": {
                return "double";
            }
            case "java.lang.Long": {
                return "int64";
            }
            case "long": {
                return "int64";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "float": {
                return "float";
            }
            case "bigdecimal": {
                return "number";
            }
            case "biginteger": {
                return "number";
            }
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "boolean": {
                return "boolean";
            }
            case "java.util.Byte": {
                return "string";
            }
            case "byte": {
                return "string";
            }
            case "map": {
                return "map";
            }
            case "date": {
                return "string";
            }
            case "localdatetime": {
                return "string";
            }
            case "localdate": {
                return "string";
            }
            case "timestamp": {
                return "string";
            }
            case "multipartfile": {
                return "file";
            }
        }
        return "object";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApiReturn processReturnType(String fullyName) {
        ApiReturn apiReturn = new ApiReturn();
        if (fullyName.startsWith("reactor.core.publisher.Flux")) {
            fullyName = fullyName.replace("reactor.core.publisher.Flux", "java.util.List");
            apiReturn.setGenericCanonicalName(fullyName);
            apiReturn.setSimpleName("java.util.List");
            return apiReturn;
        }
        if (fullyName.startsWith("java.util.concurrent.Callable") || fullyName.startsWith("java.util.concurrent.Future") || fullyName.startsWith("java.util.concurrent.CompletableFuture") || fullyName.startsWith("org.springframework.web.context.request.async.DeferredResult") || fullyName.startsWith("org.springframework.web.context.request.async.WebAsyncTask") || fullyName.startsWith("reactor.core.publisher.Mono") || fullyName.startsWith("org.springframework.http.ResponseEntity")) {
            if (!fullyName.contains("<")) {
                apiReturn.setGenericCanonicalName("java.lang.Object");
                apiReturn.setSimpleName("java.lang.Object");
                return apiReturn;
            }
            String[] strings = DocClassUtil.getSimpleGicName(fullyName);
            String newFullName = strings[0];
            if (newFullName.contains("<")) {
                apiReturn.setGenericCanonicalName(newFullName);
                apiReturn.setSimpleName(newFullName.substring(0, newFullName.indexOf("<")));
                return apiReturn;
            }
            apiReturn.setGenericCanonicalName(newFullName);
            apiReturn.setSimpleName(newFullName);
            return apiReturn;
        }
        apiReturn.setGenericCanonicalName(fullyName);
        if (fullyName.contains("<")) {
            apiReturn.setSimpleName(fullyName.substring(0, fullyName.indexOf("<")));
            return apiReturn;
        }
        apiReturn.setSimpleName(fullyName);
        return apiReturn;
    }
}

