/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.MPJTableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfo;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.annotation.EntityMapping;
import com.github.yulichang.annotation.FieldMapping;
import com.github.yulichang.exception.MPJException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;

public class MPJTableInfoHelper {
    private static final Log logger = LogFactory.getLog(TableInfoHelper.class);
    private static final Map<Class<?>, MPJTableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();
    private static final String DEFAULT_ID_NAME = "id";

    public static MPJTableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || ReflectionKit.isPrimitiveOrWrapper(clazz) || clazz == String.class || clazz.isInterface()) {
            return null;
        }
        return TABLE_INFO_CACHE.get(clazz);
    }

    public static synchronized void initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz, Class<?> mapperClass) {
        MPJTableInfo targetTableInfo = TABLE_INFO_CACHE.get(clazz);
        Configuration configuration = builderAssistant.getConfiguration();
        if (targetTableInfo != null) {
            Configuration oldConfiguration = targetTableInfo.getTableInfo().getConfiguration();
            if (!oldConfiguration.equals(configuration)) {
                MPJTableInfoHelper.initTableInfo(configuration, builderAssistant.getCurrentNamespace(), clazz, mapperClass);
            }
            return;
        }
        MPJTableInfoHelper.initTableInfo(configuration, builderAssistant.getCurrentNamespace(), clazz, mapperClass);
    }

    public static List<MPJTableInfo> getTableInfos() {
        return Collections.unmodifiableList(new ArrayList<MPJTableInfo>(TABLE_INFO_CACHE.values()));
    }

    public static synchronized MPJTableInfo initTableInfo(Configuration configuration, String currentNamespace, Class<?> clazz, Class<?> mapperClass) {
        MPJTableInfo info = TABLE_INFO_CACHE.get(clazz);
        if (info != null) {
            return info;
        }
        MPJTableInfo mpjTableInfo = new MPJTableInfo();
        mpjTableInfo.setMapperClass(mapperClass);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (tableInfo != null) {
            mpjTableInfo.setTableInfo(tableInfo);
            MPJTableInfoHelper.initMapping(mpjTableInfo);
            TABLE_INFO_CACHE.put(clazz, mpjTableInfo);
            return mpjTableInfo;
        }
        tableInfo = new TableInfo(clazz);
        mpjTableInfo.setTableInfo(tableInfo);
        tableInfo.setCurrentNamespace(currentNamespace);
        tableInfo.setConfiguration(configuration);
        GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig((Configuration)configuration);
        String[] excludeProperty = MPJTableInfoHelper.initTableName(clazz, globalConfig, tableInfo);
        List<String> excludePropertyList = excludeProperty != null && excludeProperty.length > 0 ? Arrays.asList(excludeProperty) : Collections.emptyList();
        MPJTableInfoHelper.initTableFields(clazz, globalConfig, mpjTableInfo, excludePropertyList);
        MPJTableInfoHelper.initResultMapIfNeed(tableInfo);
        TABLE_INFO_CACHE.put(clazz, mpjTableInfo);
        LambdaUtils.installCache((TableInfo)tableInfo);
        MPJTableInfoHelper.initMapping(mpjTableInfo);
        return mpjTableInfo;
    }

    public static synchronized void initTableInfo(Class<?> clazz, Class<?> mapperClass) {
        MPJTableInfo info = TABLE_INFO_CACHE.get(clazz);
        if (info != null) {
            return;
        }
        MPJTableInfo mpjTableInfo = new MPJTableInfo();
        mpjTableInfo.setMapperClass(mapperClass);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (tableInfo == null) {
            return;
        }
        mpjTableInfo.setTableInfo(tableInfo);
        MPJTableInfoHelper.initMapping(mpjTableInfo);
        TABLE_INFO_CACHE.put(clazz, mpjTableInfo);
    }

    private static void initResultMapIfNeed(TableInfo tableInfo) {
        if (tableInfo.isAutoInitResultMap() && null == tableInfo.getResultMap()) {
            String id = tableInfo.getCurrentNamespace() + ".mybatis-plus-join_" + tableInfo.getEntityType().getSimpleName();
            tableInfo.setResultMap(id);
            if (tableInfo.getConfiguration().getResultMapNames().contains(id)) {
                tableInfo.getConfiguration().getResultMap(id);
            }
            ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
            if (tableInfo.havePK()) {
                ResultMapping idMapping = new ResultMapping.Builder(tableInfo.getConfiguration(), tableInfo.getKeyProperty(), tableInfo.getKeyColumn(), tableInfo.getKeyType()).flags(Collections.singletonList(ResultFlag.ID)).build();
                resultMappings.add(idMapping);
            }
            if (CollectionUtils.isNotEmpty((Collection)tableInfo.getFieldList())) {
                tableInfo.getFieldList().forEach(i -> resultMappings.add(i.getResultMapping(tableInfo.getConfiguration())));
            }
            ResultMap resultMap = new ResultMap.Builder(tableInfo.getConfiguration(), id, tableInfo.getEntityType(), resultMappings).build();
            tableInfo.getConfiguration().addResultMap(resultMap);
        }
    }

    private static String[] initTableName(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        String tablePrefix = dbConfig.getTablePrefix();
        String schema = dbConfig.getSchema();
        boolean tablePrefixEffect = true;
        String[] excludeProperty = null;
        if (table != null) {
            if (StringUtils.isNotBlank((CharSequence)table.value())) {
                tableName = table.value();
                if (StringUtils.isNotBlank((CharSequence)tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                tableName = MPJTableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)table.schema())) {
                schema = table.schema();
            }
            if (StringUtils.isNotBlank((CharSequence)table.resultMap())) {
                tableInfo.setResultMap(table.resultMap());
            }
            tableInfo.setAutoInitResultMap(table.autoResultMap());
            excludeProperty = table.excludeProperty();
        } else {
            tableName = MPJTableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
        }
        String targetTableName = tableName;
        if (StringUtils.isNotBlank((CharSequence)tablePrefix) && tablePrefixEffect) {
            targetTableName = tablePrefix + targetTableName;
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            targetTableName = schema + "." + targetTableName;
        }
        tableInfo.setTableName(targetTableName);
        return excludeProperty;
    }

    private static String initTableNameWithDbConfig(String className, GlobalConfig.DbConfig dbConfig) {
        String tableName = className;
        if (dbConfig.isTableUnderline()) {
            tableName = StringUtils.camelToUnderline((String)tableName);
        }
        tableName = dbConfig.isCapitalMode() ? tableName.toUpperCase() : StringUtils.firstToLowerCase((String)tableName);
        return tableName;
    }

    private static void initTableFields(Class<?> clazz, GlobalConfig globalConfig, MPJTableInfo mpjTableInfo, List<String> excludeProperty) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        ReflectorFactory reflectorFactory = mpjTableInfo.getTableInfo().getConfiguration().getReflectorFactory();
        Reflector reflector = reflectorFactory.findForClass(clazz);
        List<Field> list = MPJTableInfoHelper.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existTableId = MPJTableInfoHelper.isExistTableId(list);
        boolean existTableLogic = MPJTableInfoHelper.isExistTableLogic(list);
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>(list.size());
        for (Field field : list) {
            TableField tableField;
            if (excludeProperty.contains(field.getName())) continue;
            if (existTableId) {
                TableId tableId = field.getAnnotation(TableId.class);
                if (tableId != null) {
                    if (isReadPK) {
                        throw ExceptionUtils.mpe((String)"@TableId can't more than one in Class: \"%s\".", (Object[])new Object[]{clazz.getName()});
                    }
                    MPJTableInfoHelper.initTableIdWithAnnotation(dbConfig, mpjTableInfo.getTableInfo(), field, tableId, reflector);
                    isReadPK = true;
                    continue;
                }
            } else if (!isReadPK && (isReadPK = MPJTableInfoHelper.initTableIdWithoutAnnotation(dbConfig, mpjTableInfo.getTableInfo(), field, reflector))) continue;
            if ((tableField = field.getAnnotation(TableField.class)) != null) {
                fieldList.add(new TableFieldInfo(dbConfig, mpjTableInfo.getTableInfo(), field, tableField, reflector, existTableLogic));
                continue;
            }
            fieldList.add(new TableFieldInfo(dbConfig, mpjTableInfo.getTableInfo(), field, reflector, existTableLogic));
        }
        mpjTableInfo.getTableInfo().setFieldList(fieldList);
        if (!isReadPK) {
            logger.warn(String.format("Can not find table primary key in Class: \"%s\".", clazz.getName()));
        }
    }

    public static boolean isExistTableId(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(TableId.class));
    }

    public static boolean isExistTableLogic(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(TableLogic.class));
    }

    private static boolean isExistMapping(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(EntityMapping.class));
    }

    private static boolean isExistMappingField(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(FieldMapping.class));
    }

    private static void initTableIdWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableId tableId, Reflector reflector) {
        boolean underCamel = tableInfo.isUnderCamel();
        String property = field.getName();
        if (field.getAnnotation(TableField.class) != null) {
            logger.warn(String.format("This \"%s\" is the table primary key by @TableId annotation in Class: \"%s\",So @TableField annotation will not work!", property, tableInfo.getEntityType().getName()));
        }
        if (IdType.NONE == tableId.type()) {
            tableInfo.setIdType(dbConfig.getIdType());
        } else {
            tableInfo.setIdType(tableId.type());
        }
        String column = property;
        if (StringUtils.isNotBlank((CharSequence)tableId.value())) {
            column = tableId.value();
        } else {
            if (underCamel) {
                column = StringUtils.camelToUnderline((String)column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
        }
        Class keyType = reflector.getGetterType(property);
        if (keyType.isPrimitive()) {
            logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
        }
        tableInfo.setKeyRelated(MPJTableInfoHelper.checkRelated(underCamel, property, column)).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType);
    }

    private static boolean initTableIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, Reflector reflector) {
        String property = field.getName();
        if (DEFAULT_ID_NAME.equalsIgnoreCase(property)) {
            Class keyType;
            if (field.getAnnotation(TableField.class) != null) {
                logger.warn(String.format("This \"%s\" is the table primary key by default name for `id` in Class: \"%s\",So @TableField will not work!", property, tableInfo.getEntityType().getName()));
            }
            String column = property;
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
            if ((keyType = reflector.getGetterType(property)).isPrimitive()) {
                logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
            }
            tableInfo.setKeyRelated(MPJTableInfoHelper.checkRelated(tableInfo.isUnderCamel(), property, column)).setIdType(dbConfig.getIdType()).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType);
            return true;
        }
        return false;
    }

    public static boolean checkRelated(boolean underCamel, String property, String column) {
        column = StringUtils.getTargetColumn((String)column);
        String propertyUpper = property.toUpperCase(Locale.ENGLISH);
        String columnUpper = column.toUpperCase(Locale.ENGLISH);
        if (underCamel) {
            return !propertyUpper.equals(columnUpper) && !propertyUpper.equals(columnUpper.replace("_", ""));
        }
        return !propertyUpper.equals(columnUpper);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        List fieldList = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
        return fieldList.stream().filter(field -> {
            TableField tableField = field.getAnnotation(TableField.class);
            return tableField == null || tableField.exist();
        }).collect(Collectors.toList());
    }

    public static void initMapping(MPJTableInfo mpjTableInfo) {
        boolean existMapping = MPJTableInfoHelper.isExistMapping(mpjTableInfo.getTableInfo().getEntityType());
        mpjTableInfo.setHasMapping(existMapping);
        boolean existMappingField = MPJTableInfoHelper.isExistMappingField(mpjTableInfo.getTableInfo().getEntityType());
        mpjTableInfo.setHasMappingField(existMappingField);
        mpjTableInfo.setHasMappingOrField(existMapping || existMappingField);
        ArrayList<MPJTableFieldInfo> mpjFieldList = new ArrayList<MPJTableFieldInfo>();
        List fields = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass((Class)mpjTableInfo.getTableInfo().getEntityType()));
        for (Field field : fields) {
            Annotation mapping;
            if (existMapping && (mapping = field.getAnnotation(EntityMapping.class)) != null) {
                mpjFieldList.add(new MPJTableFieldInfo((Class<?>)mpjTableInfo.getTableInfo().getEntityType(), (EntityMapping)mapping, field));
            }
            if (!existMappingField || (mapping = field.getAnnotation(FieldMapping.class)) == null) continue;
            mpjFieldList.add(new MPJTableFieldInfo(mpjTableInfo.getTableInfo().getEntityType(), (FieldMapping)mapping, field));
        }
        mpjTableInfo.setFieldList(mpjFieldList);
    }

    public static TableInfo copyAndSetTableName(TableInfo tableInfo, String tableName) {
        try {
            Field[] fields;
            TableInfo table = new TableInfo(tableInfo.getEntityType());
            for (Field f : fields = TableInfo.class.getDeclaredFields()) {
                f.setAccessible(true);
                f.set(table, f.get(tableInfo));
            }
            table.setTableName(tableName);
            return table;
        }
        catch (Exception e) {
            throw new MPJException("TableInfo \u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25 -> " + tableInfo.getEntityType().getName());
        }
    }
}

