/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.jwt;

import cn.hutool.core.convert.Convert;
import com.github.zuihou.jwt.JwtProperties;
import com.github.zuihou.jwt.model.AuthInfo;
import com.github.zuihou.jwt.model.JwtUserInfo;
import com.github.zuihou.jwt.model.Token;
import com.github.zuihou.jwt.utils.JwtUtil;
import io.jsonwebtoken.Claims;
import java.util.Date;
import java.util.HashMap;

public class TokenUtil {
    private JwtProperties authServerProperties;

    public AuthInfo createAuthInfo(JwtUserInfo userInfo, Long expireMillis) {
        if (expireMillis == null || expireMillis <= 0L) {
            expireMillis = this.authServerProperties.getExpire();
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("token_type", "token");
        param.put("userid", Convert.toStr((Object)userInfo.getUserId(), (String)"0"));
        param.put("account", userInfo.getAccount());
        param.put("name", userInfo.getName());
        Token token = JwtUtil.createJWT(param, expireMillis);
        AuthInfo authInfo = new AuthInfo();
        authInfo.setAccount(userInfo.getAccount());
        authInfo.setName(userInfo.getName());
        authInfo.setUserId(userInfo.getUserId());
        authInfo.setTokenType("token");
        authInfo.setToken(token.getToken());
        authInfo.setExpire(token.getExpire());
        authInfo.setExpiration(token.getExpiration());
        authInfo.setRefreshToken(this.createRefreshToken(userInfo).getToken());
        return authInfo;
    }

    private Token createRefreshToken(JwtUserInfo userInfo) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("token_type", "refresh_token");
        param.put("userid", Convert.toStr((Object)userInfo.getUserId(), (String)"0"));
        return JwtUtil.createJWT(param, this.authServerProperties.getRefreshExpire());
    }

    public AuthInfo getAuthInfo(String token) {
        Claims claims = JwtUtil.getClaims(token);
        String tokenType = Convert.toStr((Object)claims.get((Object)"token_type"));
        Long userId = Convert.toLong((Object)claims.get((Object)"userid"));
        String account = Convert.toStr((Object)claims.get((Object)"account"));
        String name = Convert.toStr((Object)claims.get((Object)"name"));
        Date expiration = claims.getExpiration();
        return new AuthInfo().setToken(token).setExpire(expiration != null ? expiration.getTime() : 0L).setTokenType(tokenType).setUserId(userId).setAccount(account).setName(name);
    }

    public AuthInfo parseRefreshToken(String token) {
        Claims claims = JwtUtil.parseJWT(token);
        String tokenType = Convert.toStr((Object)claims.get((Object)"token_type"));
        Long userId = Convert.toLong((Object)claims.get((Object)"userid"));
        Date expiration = claims.getExpiration();
        return new AuthInfo().setToken(token).setExpire(expiration != null ? expiration.getTime() : 0L).setTokenType(tokenType).setUserId(userId);
    }

    public TokenUtil(JwtProperties authServerProperties) {
        this.authServerProperties = authServerProperties;
    }
}

