/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.log;

import com.alibaba.fastjson.JSONObject;
import com.github.zuihou.log.aspect.SysLogAspect;
import com.github.zuihou.log.event.SysLogListener;
import com.github.zuihou.log.interceptor.MdcMvcConfigurer;
import com.github.zuihou.log.monitor.PointUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="zuihou.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SysLogAspect sysLogAspect() {
        return new SysLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${zuihou.log.enabled:true} && 'LOGGER'.equals('${zuihou.log.type:LOGGER}')")
    public SysLogListener sysLogListener() {
        return new SysLogListener(log -> PointUtil.debug("0", "OPT_LOG", JSONObject.toJSONString((Object)log)));
    }

    @ConditionalOnProperty(prefix="zuihou.webmvc", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class WebMvcConfig {
        @Bean
        public MdcMvcConfigurer getMdcMvcConfigurer() {
            return new MdcMvcConfigurer();
        }
    }
}

