/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.log.aspect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.zuihou.base.R;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.log.annotation.SysLog;
import com.github.zuihou.log.entity.OptLogDTO;
import com.github.zuihou.log.event.SysLogEvent;
import com.github.zuihou.log.util.LogUtil;
import com.github.zuihou.utils.SpringUtils;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    public static final int MAX_LENGTH = 65535;
    private static final ThreadLocal<OptLogDTO> THREAD_LOCAL = new ThreadLocal();
    private SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();

    @Pointcut(value="execution(public * com.github.zuihou.base.controller.*.*(..)) || @annotation(com.github.zuihou.log.annotation.SysLog)")
    public void sysLogAspect() {
    }

    @AfterReturning(returning="ret", pointcut="sysLogAspect()")
    public void doAfterReturning(JoinPoint joinPoint, Object ret) {
        this.tryCatch(aaa -> {
            SysLog sysLogAnno = LogUtil.getTargetAnno(joinPoint);
            if (this.check(joinPoint, sysLogAnno)) {
                return;
            }
            R r = (R)Convert.convert(R.class, (Object)ret);
            OptLogDTO sysLog = this.get();
            if (r == null) {
                sysLog.setType("OPT");
                if (sysLogAnno.response()) {
                    sysLog.setResult(this.getText(String.valueOf(ret == null ? "" : ret)));
                }
            } else {
                if (r.getIsSuccess().booleanValue()) {
                    sysLog.setType("OPT");
                } else {
                    sysLog.setType("EX");
                    sysLog.setExDetail(r.getMsg());
                }
                if (sysLogAnno.response()) {
                    sysLog.setResult(this.getText(r.toString()));
                }
            }
            this.publishEvent(sysLog);
        });
    }

    @AfterThrowing(pointcut="sysLogAspect()", throwing="e")
    public void doAfterThrowable(JoinPoint joinPoint, Throwable e) {
        this.tryCatch(aaa -> {
            SysLog sysLogAnno = LogUtil.getTargetAnno(joinPoint);
            if (this.check(joinPoint, sysLogAnno)) {
                return;
            }
            OptLogDTO sysLog = this.get();
            sysLog.setType("EX");
            if (!sysLogAnno.request() && sysLogAnno.requestByError() && StrUtil.isEmpty((CharSequence)sysLog.getParams())) {
                Object[] args = joinPoint.getArgs();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                String strArgs = this.getArgs(sysLogAnno, args, request);
                sysLog.setParams(this.getText(strArgs));
            }
            sysLog.setExDetail(ExceptionUtil.stacktraceToString((Throwable)e, (int)65535));
            sysLog.setExDesc(ExceptionUtil.stacktraceToString((Throwable)e, (int)65535));
            this.publishEvent(sysLog);
        });
    }

    @Before(value="sysLogAspect()")
    public void recordLog(JoinPoint joinPoint) throws Throwable {
        this.tryCatch(val -> {
            Object[] args;
            String controllerMethodDescription;
            String[] tags;
            SysLog sysLogAnno = LogUtil.getTargetAnno(joinPoint);
            if (this.check(joinPoint, sysLogAnno)) {
                return;
            }
            OptLogDTO sysLog = this.get();
            sysLog.setCreateUser(BaseContextHandler.getUserId());
            sysLog.setUserName(BaseContextHandler.getName());
            String controllerDescription = "";
            Api api = joinPoint.getTarget().getClass().getAnnotation(Api.class);
            if (api != null && (tags = api.tags()) != null && tags.length > 0) {
                controllerDescription = tags[0];
            }
            if (StrUtil.isNotEmpty((CharSequence)(controllerMethodDescription = LogUtil.getDescribe(sysLogAnno))) && StrUtil.contains((CharSequence)controllerMethodDescription, (CharSequence)"#")) {
                args = joinPoint.getArgs();
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                controllerMethodDescription = this.getValBySpEL(controllerMethodDescription, methodSignature, args);
            }
            if (StrUtil.isEmpty((CharSequence)controllerDescription)) {
                sysLog.setDescription(controllerMethodDescription);
            } else if (sysLogAnno.controllerApiValue()) {
                sysLog.setDescription(controllerDescription + "-" + controllerMethodDescription);
            } else {
                sysLog.setDescription(controllerMethodDescription);
            }
            sysLog.setClassPath(joinPoint.getTarget().getClass().getName());
            sysLog.setActionMethod(joinPoint.getSignature().getName());
            args = joinPoint.getArgs();
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            if (sysLogAnno.request()) {
                String strArgs = this.getArgs(sysLogAnno, args, request);
                sysLog.setParams(this.getText(strArgs));
            }
            sysLog.setTrace(MDC.get((String)"trace"));
            if (request != null) {
                sysLog.setRequestIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
                sysLog.setRequestUri(URLUtil.getPath((String)request.getRequestURI()));
                sysLog.setHttpMethod(request.getMethod());
                sysLog.setUa(StrUtil.sub((CharSequence)request.getHeader("user-agent"), (int)0, (int)500));
                if (BaseContextHandler.getBoot().booleanValue()) {
                    sysLog.setTenantCode(BaseContextHandler.getTenant());
                } else {
                    sysLog.setTenantCode(request.getHeader("tenant"));
                }
                if (StrUtil.isEmpty((CharSequence)sysLog.getTrace())) {
                    sysLog.setTrace(request.getHeader("x-trace-header"));
                }
            }
            sysLog.setStartTime(LocalDateTime.now());
            THREAD_LOCAL.set(sysLog);
        });
    }

    private boolean check(JoinPoint joinPoint, SysLog sysLogAnno) {
        if (sysLogAnno == null || !sysLogAnno.enabled()) {
            return true;
        }
        SysLog targetClass = joinPoint.getTarget().getClass().getAnnotation(SysLog.class);
        return targetClass != null && !targetClass.enabled();
    }

    private OptLogDTO get() {
        OptLogDTO sysLog = THREAD_LOCAL.get();
        if (sysLog == null) {
            return new OptLogDTO();
        }
        return sysLog;
    }

    private void tryCatch(Consumer<String> consumer) {
        try {
            consumer.accept("");
        }
        catch (Exception e) {
            log.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            THREAD_LOCAL.remove();
        }
    }

    private void publishEvent(OptLogDTO sysLog) {
        sysLog.setFinishTime(LocalDateTime.now());
        sysLog.setConsumingTime(sysLog.getStartTime().until(sysLog.getFinishTime(), ChronoUnit.MILLIS));
        SpringUtils.publishEvent((Object)((Object)new SysLogEvent(sysLog)));
        THREAD_LOCAL.remove();
    }

    private String getText(String val) {
        return StrUtil.sub((CharSequence)val, (int)0, (int)65535);
    }

    private String getArgs(SysLog sysLogAnno, Object[] args, HttpServletRequest request) {
        String strArgs = "";
        try {
            if (!request.getContentType().contains("multipart/form-data")) {
                strArgs = JSONObject.toJSONString((Object)args);
            }
        }
        catch (Exception e) {
            try {
                strArgs = Arrays.toString(args);
            }
            catch (Exception ex) {
                log.warn("\u89e3\u6790\u53c2\u6570\u5f02\u5e38", (Throwable)ex);
            }
        }
        return strArgs;
    }

    private String getValBySpEL(String spEL, MethodSignature methodSignature, Object[] args) {
        try {
            String[] paramNames = this.nameDiscoverer.getParameterNames(methodSignature.getMethod());
            if (paramNames != null && paramNames.length > 0) {
                Expression expression = this.spelExpressionParser.parseExpression(spEL);
                StandardEvaluationContext context = new StandardEvaluationContext();
                for (int i = 0; i < args.length; ++i) {
                    context.setVariable(paramNames[i], args[i]);
                    context.setVariable("p" + i, args[i]);
                }
                return expression.getValue((EvaluationContext)context).toString();
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u64cd\u4f5c\u65e5\u5fd7\u7684el\u8868\u8fbe\u5f0f\u51fa\u9519", (Throwable)e);
        }
        return spEL;
    }
}

