/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.log.interceptor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.github.zuihou.context.BaseContextHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MdcHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(MdcHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return super.preHandle(request, response, handler);
        }
        if (!BaseContextHandler.getBoot().booleanValue()) {
            String traceId = request.getHeader("x-trace-header");
            MDC.put((String)"trace", (String)(StrUtil.isEmpty((CharSequence)traceId) ? "" : traceId));
            MDC.put((String)"tenant", (String)this.getHeader(request, "tenant"));
            MDC.put((String)"userid", (String)this.getHeader(request, "userid"));
        }
        return super.preHandle(request, response, handler);
    }

    private String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (StringUtils.isEmpty((Object)value)) {
            return "";
        }
        return URLUtil.decode((String)value);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        BaseContextHandler.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

