/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.log.util;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.lionsoul.ip2region.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);
    private static final String JAVA_TEMP_DIR = "java.io.tmpdir";
    static DbConfig config = null;
    static DbSearcher searcher = null;

    public static String getRegion(String ip) {
        try {
            if (searcher == null || StrUtil.isEmpty((CharSequence)ip)) {
                log.error("DbSearcher is null");
                return "";
            }
            long startTime = System.currentTimeMillis();
            int algorithm = 3;
            Method method = null;
            switch (algorithm) {
                case 1: {
                    method = searcher.getClass().getMethod("btreeSearch", String.class);
                    break;
                }
                case 2: {
                    method = searcher.getClass().getMethod("binarySearch", String.class);
                    break;
                }
                case 3: {
                    method = searcher.getClass().getMethod("memorySearch", String.class);
                }
            }
            DataBlock dataBlock = null;
            if (!Util.isIpAddress((String)ip)) {
                log.warn("warning: Invalid ip address");
            }
            if (method == null) {
                log.warn("\u8b66\u544a: \u67e5\u8be2\u7b97\u6cd5\u4e0d\u5b58\u5728");
                return "";
            }
            dataBlock = (DataBlock)method.invoke((Object)searcher, ip);
            String result = dataBlock != null ? dataBlock.getRegion() : "";
            long endTime = System.currentTimeMillis();
            log.debug("region use time[{}] result[{}]", (Object)(endTime - startTime), (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("error:{}", (Throwable)e);
            return "";
        }
    }

    static {
        try {
            String dbPath = AddressUtil.class.getResource("/ip2region/ip2region.db").getPath();
            File file = new File(dbPath);
            if (!file.exists()) {
                String tmpDir = System.getProperties().getProperty(JAVA_TEMP_DIR);
                dbPath = tmpDir + "ip2region.db";
                file = new File(dbPath);
                String classPath = "classpath:ip2region/ip2region.db";
                InputStream resourceAsStream = ResourceUtil.getStreamSafe((String)classPath);
                if (resourceAsStream != null) {
                    FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)file);
                }
            }
            config = new DbConfig();
            searcher = new DbSearcher(config, dbPath);
            log.info("bean [{}]", (Object)config);
            log.info("bean [{}]", (Object)searcher);
        }
        catch (Exception e) {
            log.error("init ip region error:{}", (Throwable)e);
        }
    }
}

