/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.RelativeUnixPath;
import com.google.cloud.tools.jib.filesystem.UnixPathParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringJoiner;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AbsoluteUnixPath {
    private final ImmutableList<String> pathComponents;
    private final String unixPath;

    public static AbsoluteUnixPath get(String unixPath) {
        Preconditions.checkArgument((boolean)unixPath.startsWith("/"), (Object)("Path does not start with forward slash (/): " + unixPath));
        return new AbsoluteUnixPath(UnixPathParser.parse(unixPath));
    }

    public static AbsoluteUnixPath fromPath(Path path) {
        Preconditions.checkArgument((path.getRoot() != null ? 1 : 0) != 0, (Object)("Cannot create AbsoluteUnixPath from non-absolute Path: " + path));
        ImmutableList.Builder pathComponents = ImmutableList.builderWithExpectedSize((int)path.getNameCount());
        for (Path pathComponent : path) {
            pathComponents.add((Object)pathComponent.toString());
        }
        return new AbsoluteUnixPath((ImmutableList<String>)pathComponents.build());
    }

    private AbsoluteUnixPath(ImmutableList<String> pathComponents) {
        this.pathComponents = pathComponents;
        StringJoiner pathJoiner = new StringJoiner("/", "/", "");
        for (String pathComponent : pathComponents) {
            pathJoiner.add(pathComponent);
        }
        this.unixPath = pathJoiner.toString();
    }

    public AbsoluteUnixPath resolve(RelativeUnixPath relativeUnixPath) {
        ImmutableList.Builder newPathComponents = ImmutableList.builderWithExpectedSize((int)(this.pathComponents.size() + relativeUnixPath.getRelativePathComponents().size()));
        newPathComponents.addAll(this.pathComponents);
        newPathComponents.addAll(relativeUnixPath.getRelativePathComponents());
        return new AbsoluteUnixPath((ImmutableList<String>)newPathComponents.build());
    }

    public AbsoluteUnixPath resolve(Path relativePath) {
        Preconditions.checkArgument((relativePath.getRoot() == null ? 1 : 0) != 0, (Object)("Cannot resolve against absolute Path: " + relativePath));
        return AbsoluteUnixPath.fromPath(Paths.get(this.unixPath, new String[0]).resolve(relativePath));
    }

    public AbsoluteUnixPath resolve(String relativeUnixPath) {
        return this.resolve(RelativeUnixPath.get(relativeUnixPath));
    }

    public String toString() {
        return this.unixPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbsoluteUnixPath)) {
            return false;
        }
        AbsoluteUnixPath otherAbsoluteUnixPath = (AbsoluteUnixPath)other;
        return this.unixPath.equals(otherAbsoluteUnixPath.unixPath);
    }

    public int hashCode() {
        return this.unixPath.hashCode();
    }
}

