/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageFormat;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LayerEntry;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.Port;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class JibContainerBuilder {
    private final ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder();
    private final BuildConfiguration.Builder buildConfigurationBuilder;
    private List<LayerConfiguration> layerConfigurations = new ArrayList<LayerConfiguration>();

    private static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    JibContainerBuilder(RegistryImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference()).setCredentialRetrievers(baseImage.getCredentialRetrievers()).build(), BuildConfiguration.builder());
    }

    JibContainerBuilder(DockerDaemonImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference()).setDockerClient(new DockerClient(baseImage.getDockerExecutable(), baseImage.getDockerEnvironment())).build(), BuildConfiguration.builder());
    }

    JibContainerBuilder(TarImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference().orElse(ImageReference.scratch())).setTarPath(baseImage.getPath()).build(), BuildConfiguration.builder());
    }

    @VisibleForTesting
    JibContainerBuilder(ImageConfiguration imageConfiguration, BuildConfiguration.Builder buildConfigurationBuilder) {
        this.buildConfigurationBuilder = buildConfigurationBuilder.setBaseImageConfiguration(imageConfiguration);
    }

    public JibContainerBuilder addLayer(List<Path> files, AbsoluteUnixPath pathInContainer) throws IOException {
        LayerConfiguration.Builder layerConfigurationBuilder = LayerConfiguration.builder();
        for (Path file : files) {
            layerConfigurationBuilder.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()));
        }
        return this.addLayer(layerConfigurationBuilder.build());
    }

    public JibContainerBuilder addLayer(List<Path> files, String pathInContainer) throws IOException {
        return this.addLayer(files, AbsoluteUnixPath.get(pathInContainer));
    }

    public JibContainerBuilder addLayer(LayerConfiguration layerConfiguration) {
        this.layerConfigurations.add(layerConfiguration);
        return this;
    }

    public JibContainerBuilder setLayers(List<LayerConfiguration> layerConfigurations) {
        this.layerConfigurations = new ArrayList<LayerConfiguration>(layerConfigurations);
        return this;
    }

    public JibContainerBuilder setLayers(LayerConfiguration ... layerConfigurations) {
        return this.setLayers(Arrays.asList(layerConfigurations));
    }

    public JibContainerBuilder setEntrypoint(@Nullable List<String> entrypoint) {
        this.containerConfigurationBuilder.setEntrypoint(entrypoint);
        return this;
    }

    public JibContainerBuilder setEntrypoint(String ... entrypoint) {
        return this.setEntrypoint(Arrays.asList(entrypoint));
    }

    public JibContainerBuilder setProgramArguments(@Nullable List<String> programArguments) {
        this.containerConfigurationBuilder.setProgramArguments(programArguments);
        return this;
    }

    public JibContainerBuilder setProgramArguments(String ... programArguments) {
        return this.setProgramArguments(Arrays.asList(programArguments));
    }

    public JibContainerBuilder setEnvironment(Map<String, String> environmentMap) {
        this.containerConfigurationBuilder.setEnvironment(environmentMap);
        return this;
    }

    public JibContainerBuilder addEnvironmentVariable(String name, String value) {
        this.containerConfigurationBuilder.addEnvironment(name, value);
        return this;
    }

    public JibContainerBuilder setVolumes(Set<AbsoluteUnixPath> volumes) {
        this.containerConfigurationBuilder.setVolumes(volumes);
        return this;
    }

    public JibContainerBuilder setVolumes(AbsoluteUnixPath ... volumes) {
        return this.setVolumes(new HashSet<AbsoluteUnixPath>(Arrays.asList(volumes)));
    }

    public JibContainerBuilder addVolume(AbsoluteUnixPath volume) {
        this.containerConfigurationBuilder.addVolume(volume);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Set<Port> ports) {
        this.containerConfigurationBuilder.setExposedPorts(ports);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Port ... ports) {
        return this.setExposedPorts(new HashSet<Port>(Arrays.asList(ports)));
    }

    public JibContainerBuilder addExposedPort(Port port) {
        this.containerConfigurationBuilder.addExposedPort(port);
        return this;
    }

    public JibContainerBuilder setLabels(Map<String, String> labelMap) {
        this.containerConfigurationBuilder.setLabels(labelMap);
        return this;
    }

    public JibContainerBuilder addLabel(String key, String value) {
        this.containerConfigurationBuilder.addLabel(key, value);
        return this;
    }

    public JibContainerBuilder setFormat(ImageFormat imageFormat) {
        this.buildConfigurationBuilder.setTargetFormat(imageFormat);
        return this;
    }

    public JibContainerBuilder setCreationTime(Instant creationTime) {
        this.containerConfigurationBuilder.setCreationTime(creationTime);
        return this;
    }

    public JibContainerBuilder setUser(@Nullable String user) {
        this.containerConfigurationBuilder.setUser(user);
        return this;
    }

    public JibContainerBuilder setWorkingDirectory(@Nullable AbsoluteUnixPath workingDirectory) {
        this.containerConfigurationBuilder.setWorkingDirectory(workingDirectory);
        return this;
    }

    public JibContainer containerize(Containerizer containerizer) throws InterruptedException, RegistryException, IOException, CacheDirectoryCreationException, ExecutionException {
        return this.containerize(containerizer, Executors::newCachedThreadPool);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    JibContainer containerize(Containerizer containerizer, Supplier<ExecutorService> defaultExecutorServiceFactory) throws IOException, CacheDirectoryCreationException, InterruptedException, RegistryException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    BuildConfiguration toBuildConfiguration(Containerizer containerizer, ExecutorService executorService) throws CacheDirectoryCreationException, IOException {
        return this.buildConfigurationBuilder.setTargetImageConfiguration(containerizer.getImageConfiguration()).setAdditionalTargetImageTags(containerizer.getAdditionalTags()).setBaseImageLayersCacheDirectory(containerizer.getBaseImageLayersCacheDirectory()).setApplicationLayersCacheDirectory(containerizer.getApplicationLayersCacheDirectory()).setContainerConfiguration(this.containerConfigurationBuilder.build()).setLayerConfigurations(this.layerConfigurations).setAllowInsecureRegistries(containerizer.getAllowInsecureRegistries()).setOffline(containerizer.isOfflineMode()).setToolName(containerizer.getToolName()).setExecutorService(executorService).setEventHandlers(containerizer.buildEventHandlers()).build();
    }

    private void logSources(EventHandlers eventHandlers) {
        eventHandlers.dispatch(LogEvent.info("Containerizing application with the following files:"));
        for (LayerConfiguration layerConfiguration : this.layerConfigurations) {
            if (layerConfiguration.getLayerEntries().isEmpty()) continue;
            eventHandlers.dispatch(LogEvent.info("\t" + JibContainerBuilder.capitalizeFirstLetter(layerConfiguration.getName()) + ":"));
            for (LayerEntry layerEntry : layerConfiguration.getLayerEntries()) {
                eventHandlers.dispatch(LogEvent.info("\t\t" + layerEntry.getSourceFile()));
            }
        }
    }
}

