/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.docker.ImageTarball;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DockerClient {
    public static final Path DEFAULT_DOCKER_CLIENT = Paths.get("docker", new String[0]);
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    public static boolean isDefaultDockerInstalled() {
        return DockerClient.isDockerInstalled(DEFAULT_DOCKER_CLIENT);
    }

    public static boolean isDockerInstalled(Path dockerExecutable) {
        try {
            new ProcessBuilder(dockerExecutable.toString()).start();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @VisibleForTesting
    static Function<List<String>, ProcessBuilder> defaultProcessBuilderFactory(String dockerExecutable, ImmutableMap<String, String> dockerEnvironment) {
        return dockerSubCommand -> {
            ArrayList<String> dockerCommand = new ArrayList<String>(1 + dockerSubCommand.size());
            dockerCommand.add(dockerExecutable);
            dockerCommand.addAll((Collection<String>)dockerSubCommand);
            ProcessBuilder processBuilder = new ProcessBuilder(dockerCommand);
            Map<String, String> environment = processBuilder.environment();
            environment.putAll((Map<String, String>)dockerEnvironment);
            return processBuilder;
        };
    }

    public DockerClient(Path dockerExecutable, Map<String, String> dockerEnvironment) {
        this(DockerClient.defaultProcessBuilderFactory(dockerExecutable.toString(), (ImmutableMap<String, String>)ImmutableMap.copyOf(dockerEnvironment)));
    }

    @VisibleForTesting
    DockerClient(Function<List<String>, ProcessBuilder> processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public String load(ImageTarball imageTarball, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Throwable throwable;
        Process dockerProcess = this.docker("load");
        try {
            throwable = null;
            try (NotifyingOutputStream stdin = new NotifyingOutputStream(dockerProcess.getOutputStream(), writtenByteCountListener);){
                imageTarball.writeTo(stdin);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            String error;
            try (InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);){
                error = CharStreams.toString((Readable)stderr);
            }
            catch (IOException ignored) {
                throw ex;
            }
            throw new IOException("'docker load' command failed with error: " + error, ex);
        }
        throwable = null;
        try (InputStreamReader stdout = new InputStreamReader(dockerProcess.getInputStream(), StandardCharsets.UTF_8);){
            String output = CharStreams.toString((Readable)stdout);
            if (dockerProcess.waitFor() != 0) {
                InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
                Throwable throwable3 = null;
                try {
                    try {
                        throw new IOException("'docker load' command failed with output: " + CharStreams.toString((Readable)stderr));
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    DockerClient.$closeResource(throwable3, stderr);
                    throw throwable5;
                }
            }
            String string = output;
            return string;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
    }

    public void save(ImageReference imageReference, Path outputPath, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("save", imageReference.toString());
        try (BufferedInputStream stdout = new BufferedInputStream(dockerProcess.getInputStream());
             NotifyingOutputStream fileStream = new NotifyingOutputStream(new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0])), writtenByteCountListener);){
            ByteStreams.copy((InputStream)stdout, (OutputStream)fileStream);
        }
        if (dockerProcess.waitFor() != 0) {
            InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
            var6_6 = null;
            try {
                try {
                    throw new IOException("'docker save' command failed with output: " + CharStreams.toString((Readable)stderr));
                }
                catch (Throwable throwable) {
                    var6_6 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                DockerClient.$closeResource(var6_6, stderr);
                throw throwable;
            }
        }
    }

    public void tag(ImageReference originalImageReference, ImageReference newImageReference) throws IOException, InterruptedException {
        Process dockerProcess = this.docker("tag", originalImageReference.toString(), newImageReference.toString());
        if (dockerProcess.waitFor() != 0) {
            InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                try {
                    throw new IOException("'docker tag' command failed with error: " + CharStreams.toString((Readable)stderr));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                DockerClient.$closeResource(throwable, stderr);
                throw throwable3;
            }
        }
    }

    public long sizeOf(ImageReference imageReference) throws IOException {
        Process sizeProcess = this.docker("inspect", "-f", "{{.Size}}", imageReference.toString());
        return Long.parseLong(CharStreams.toString((Readable)new InputStreamReader(sizeProcess.getInputStream(), StandardCharsets.UTF_8)).trim());
    }

    private Process docker(String ... subCommand) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(subCommand)).start();
    }
}

