/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.progress;

import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ThrottledAccumulatingConsumer
implements Consumer<Long>,
Closeable {
    private final Consumer<Long> consumer;
    private final Duration delayBetweenCallbacks;
    private Instant previousCallback;
    private final Supplier<Instant> getNow;
    @Nullable
    private Long valueSoFar;

    public ThrottledAccumulatingConsumer(Consumer<Long> callback) {
        this(callback, Duration.ofMillis(100L), Instant::now);
    }

    public ThrottledAccumulatingConsumer(Consumer<Long> consumer, Duration delayBetweenCallbacks, Supplier<Instant> getNow) {
        this.consumer = consumer;
        this.delayBetweenCallbacks = delayBetweenCallbacks;
        this.getNow = getNow;
        this.previousCallback = getNow.get();
    }

    @Override
    public void accept(Long value) {
        Instant nextFireTime;
        this.valueSoFar = this.valueSoFar == null ? value : this.valueSoFar + value;
        Instant now = this.getNow.get();
        if (now.isAfter(nextFireTime = this.previousCallback.plus(this.delayBetweenCallbacks))) {
            this.consumer.accept(this.valueSoFar);
            this.previousCallback = now;
            this.valueSoFar = null;
        }
    }

    @Override
    public void close() {
        if (this.valueSoFar != null) {
            this.consumer.accept(this.valueSoFar);
        }
    }
}

