/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.PathConsumer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;

public class FileOperations {
    public static void copy(ImmutableList<Path> sourceFiles, Path destDir) throws IOException {
        for (Path sourceFile : sourceFiles) {
            PathConsumer copyPathConsumer = path -> {
                Path destPath = destDir.resolve(sourceFile.getParent().relativize(path));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(path, destPath, new CopyOption[0]);
                }
            };
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                new DirectoryWalker(sourceFile).walk(copyPathConsumer);
                continue;
            }
            copyPathConsumer.accept(sourceFile);
        }
    }

    public static OutputStream newLockingOutputStream(Path file) throws IOException {
        EnumSet<StandardOpenOption> createOrTruncate = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        FileChannel channel = FileChannel.open(file, createOrTruncate, new FileAttribute[0]);
        channel.lock();
        return Channels.newOutputStream(channel);
    }

    private FileOperations() {
    }
}

