/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class V21ManifestTemplate
implements ManifestTemplate {
    public static final String MEDIA_TYPE = "application/vnd.docker.distribution.manifest.v1+json";
    private final int schemaVersion = 1;
    private final List<LayerObjectTemplate> fsLayers = new ArrayList<LayerObjectTemplate>();
    private final List<HistoryObjectTemplate> history = new ArrayList<HistoryObjectTemplate>();

    public List<DescriptorDigest> getLayerDigests() {
        ArrayList<DescriptorDigest> layerDigests = new ArrayList<DescriptorDigest>();
        for (LayerObjectTemplate layerObjectTemplate : this.fsLayers) {
            layerDigests.add(layerObjectTemplate.blobSum);
        }
        return layerDigests;
    }

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public List<LayerObjectTemplate> getFsLayers() {
        return Collections.unmodifiableList(this.fsLayers);
    }

    public Optional<ContainerConfigurationTemplate> getContainerConfiguration() {
        try {
            if (this.history.isEmpty()) {
                return Optional.empty();
            }
            String v1Compatibility = this.history.get(0).v1Compatibility;
            if (v1Compatibility == null) {
                return Optional.empty();
            }
            return Optional.of(JsonTemplateMapper.readJson(v1Compatibility, ContainerConfigurationTemplate.class));
        }
        catch (IOException ex) {
            return Optional.empty();
        }
    }

    private static class HistoryObjectTemplate
    implements JsonTemplate {
        @Nullable
        private String v1Compatibility;

        private HistoryObjectTemplate() {
        }
    }

    @VisibleForTesting
    static class LayerObjectTemplate
    implements JsonTemplate {
        @Nullable
        private DescriptorDigest blobSum;

        LayerObjectTemplate() {
        }

        @Nullable
        DescriptorDigest getDigest() {
            return this.blobSum;
        }
    }
}

