/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.InferredAuthException;
import com.google.cloud.tools.jib.plugins.common.InferredAuthProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

class MavenSettingsServerCredentials
implements InferredAuthProvider {
    static final String CREDENTIAL_SOURCE = "Maven settings file";
    private final Settings settings;
    private final SettingsDecrypter decrypter;

    MavenSettingsServerCredentials(Settings settings, SettingsDecrypter decrypter) {
        this.settings = settings;
        this.decrypter = decrypter;
    }

    @Override
    public Optional<AuthProperty> inferAuth(String registry) throws InferredAuthException {
        Server server = this.getServerFromMavenSettings(registry);
        if (server == null) {
            return Optional.empty();
        }
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
            throw new InferredAuthException("Unable to decrypt server(" + registry + ") info from settings.xml: " + problem);
        }
        Server resultServer = result.getServer();
        final String username = resultServer.getUsername();
        final String password = resultServer.getPassword();
        return Optional.of(new AuthProperty(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getAuthDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getUsernameDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getPasswordDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }
        });
    }

    @Nullable
    @VisibleForTesting
    Server getServerFromMavenSettings(String registry) {
        Server server = this.settings.getServer(registry);
        if (server != null) {
            return server;
        }
        int index = registry.lastIndexOf(58);
        if (index != -1) {
            return this.settings.getServer(registry.substring(0, index));
        }
        return null;
    }
}

