/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarExtractor {
    public static void extract(Path source, Path destination) throws IOException {
        String canonicalDestination = destination.toFile().getCanonicalPath();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry entry = tarArchiveInputStream.getNextTarEntry();
            while (entry != null) {
                Path entryPath = destination.resolve(entry.getName());
                String canonicalTarget = entryPath.toFile().getCanonicalPath();
                if (!canonicalTarget.startsWith(canonicalDestination + File.separator)) {
                    String offender = entry.getName() + " from " + source;
                    throw new IOException("Blocked unzipping files outside destination: " + offender);
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    if (entryPath.getParent() != null) {
                        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    }
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(entryPath, new OpenOption[0]));){
                        ByteStreams.copy((InputStream)tarArchiveInputStream, (OutputStream)out);
                    }
                }
                entry = tarArchiveInputStream.getNextTarEntry();
            }
        }
    }
}

