/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.CommonDictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.EasyDictionary;
import com.hankcs.hanlp.corpus.dictionary.TFDictionary;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.NT;
import com.hankcs.hanlp.corpus.util.Precompiler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class NTDictionaryMaker
extends CommonDictionaryMaker {
    TFDictionary tfDictionary = new TFDictionary();

    public NTDictionaryMaker(EasyDictionary dictionary) {
        super(dictionary);
    }

    @Override
    protected void addToDictionary(List<List<IWord>> sentenceList) {
        for (List<IWord> wordList : sentenceList) {
            for (IWord word : wordList) {
                if (word.getLabel().equals(NT.Z.toString())) continue;
                this.dictionaryMaker.add(word);
            }
        }
        for (List<IWord> wordList : sentenceList) {
            IWord pre = null;
            for (IWord word : wordList) {
                if (pre != null) {
                    this.nGramDictionaryMaker.addPair(pre, word);
                }
                pre = word;
            }
        }
    }

    @Override
    protected void roleTag(List<List<IWord>> sentenceList) {
        int i = 0;
        for (List<IWord> wordList : sentenceList) {
            IWord current;
            Precompiler.compileWithoutNT(wordList);
            if (this.verbose) {
                System.out.print(++i + " / " + sentenceList.size() + " ");
                System.out.println("\u539f\u59cb\u8bed\u6599 " + wordList);
            }
            LinkedList wordLinkedList = (LinkedList)wordList;
            wordLinkedList.addFirst(new Word("\u59cb##\u59cb", "S"));
            wordLinkedList.addLast(new Word("\u672b##\u672b", "Z"));
            if (this.verbose) {
                System.out.println("\u6dfb\u52a0\u9996\u5c3e " + wordList);
            }
            Iterator iterator = wordLinkedList.iterator();
            IWord pre = (IWord)iterator.next();
            while (iterator.hasNext()) {
                current = (IWord)iterator.next();
                if (current.getLabel().startsWith("nt") && !pre.getLabel().startsWith("nt")) {
                    pre.setLabel(NT.A.toString());
                }
                pre = current;
            }
            if (this.verbose) {
                System.out.println("\u6807\u6ce8\u4e0a\u6587 " + wordList);
            }
            iterator = wordLinkedList.descendingIterator();
            pre = (IWord)iterator.next();
            while (iterator.hasNext()) {
                current = (IWord)iterator.next();
                if (current.getLabel().startsWith("nt") && !pre.getLabel().startsWith("nt")) {
                    pre.setLabel(NT.B.toString());
                }
                pre = current;
            }
            if (this.verbose) {
                System.out.println("\u6807\u6ce8\u4e0b\u6587 " + wordList);
            }
            iterator = wordLinkedList.iterator();
            IWord first = (IWord)iterator.next();
            IWord second = (IWord)iterator.next();
            while (iterator.hasNext()) {
                IWord third = (IWord)iterator.next();
                if (first.getLabel().startsWith("nt") && third.getLabel().startsWith("nt") && !second.getLabel().startsWith("nt")) {
                    second.setLabel(NT.X.toString());
                }
                first = second;
                second = third;
            }
            if (this.verbose) {
                System.out.println("\u6807\u6ce8\u4e2d\u95f4 " + wordList);
            }
            ListIterator<Word> listIterator = wordLinkedList.listIterator();
            while (listIterator.hasNext()) {
                IWord word = (IWord)listIterator.next();
                String label = word.getLabel();
                if (label.equals(label.toUpperCase())) continue;
                if (label.startsWith("nt")) {
                    StringBuilder sbPattern = new StringBuilder();
                    if (word instanceof CompoundWord) {
                        listIterator.remove();
                        Word last = null;
                        Iterator<Word> iterator2 = ((CompoundWord)word).innerList.iterator();
                        while (iterator2.hasNext()) {
                            Word inner;
                            last = inner = iterator2.next();
                            String innerLabel = inner.label;
                            if (innerLabel.startsWith("ns")) {
                                inner.setValue("\u672a##\u5730");
                                inner.setLabel(NT.G.toString());
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if (innerLabel.startsWith("nt")) {
                                inner.value = "\u672a##\u56e2";
                                inner.label = NT.K.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if (innerLabel.equals("b") || innerLabel.equals("ng") || innerLabel.equals("j")) {
                                inner.label = NT.J.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if ("n".equals(innerLabel) || "an".equals(innerLabel) || "a".equals(innerLabel) || "vn".equals(innerLabel) || "vd".equals(innerLabel) || "vl".equals(innerLabel) || "v".equals(innerLabel) || "vi".equals(innerLabel) || "nnt".equals(innerLabel) || "nnd".equals(innerLabel) || "nf".equals(innerLabel) || "cc".equals(innerLabel) || "t".equals(innerLabel) || "z".equals(innerLabel)) {
                                inner.label = NT.C.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if ("nz".equals(innerLabel)) {
                                inner.label = NT.I.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if ("m".equals(innerLabel)) {
                                inner.value = "\u672a##\u6570";
                                inner.label = NT.M.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if ("w".equals(innerLabel)) {
                                inner.label = NT.W.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if (innerLabel.startsWith("nr") || "x".equals(innerLabel) || "nx".equals(innerLabel)) {
                                inner.value = "\u672a##\u4eba";
                                inner.label = NT.F.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if (innerLabel.startsWith("ni")) {
                                inner.label = NT.D.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            if ("f".equals(innerLabel) || "s".equals(innerLabel)) {
                                inner.label = NT.L.toString();
                                listIterator.add(inner);
                                sbPattern.append(inner.label);
                                continue;
                            }
                            inner.label = NT.P.toString();
                            listIterator.add(inner);
                            sbPattern.append(inner.label);
                        }
                        if (last == null) continue;
                        last.label = NT.D.toString();
                        sbPattern.deleteCharAt(sbPattern.length() - 1);
                        sbPattern.append(last.label);
                        this.tfDictionary.add(sbPattern.toString());
                        sbPattern.setLength(0);
                        continue;
                    }
                    word.setLabel(NT.K.toString());
                    continue;
                }
                word.setLabel(NT.Z.toString());
            }
            if (this.verbose) {
                System.out.println("\u5904\u7406\u6574\u4e2a " + wordList);
            }
            ((IWord)wordLinkedList.getFirst()).setLabel(NT.S.toString());
        }
    }

    @Override
    public boolean saveTxtTo(String path) {
        if (!super.saveTxtTo(path)) {
            return false;
        }
        return this.tfDictionary.saveKeyTo(path + ".pattern.txt");
    }
}

