/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.crfpp.DecoderFeatureIndex;
import com.hankcs.hanlp.model.crf.crfpp.FeatureIndex;
import com.hankcs.hanlp.model.crf.crfpp.ModelImpl;
import com.hankcs.hanlp.model.crf.crfpp.Node;
import com.hankcs.hanlp.model.crf.crfpp.Path;
import com.hankcs.hanlp.model.crf.crfpp.Tagger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class TaggerImpl
extends Tagger {
    Mode mode_ = Mode.TEST;
    int vlevel_ = 0;
    int nbest_ = 0;
    int ysize_;
    double cost_;
    double Z_;
    int feature_id_;
    int thread_id_;
    FeatureIndex feature_index_;
    List<List<String>> x_;
    List<List<Node>> node_;
    List<Integer> answer_;
    List<Integer> result_;
    String lastError;
    PriorityQueue<QueueElement> agenda_;
    List<List<Double>> penalty_;
    List<List<Integer>> featureCache_;

    public TaggerImpl(Mode mode) {
        this.mode_ = mode;
        this.vlevel_ = 0;
        this.nbest_ = 0;
        this.ysize_ = 0;
        this.Z_ = 0.0;
        this.feature_id_ = 0;
        this.thread_id_ = 0;
        this.lastError = null;
        this.feature_index_ = null;
        this.x_ = new ArrayList<List<String>>();
        this.node_ = new ArrayList<List<Node>>();
        this.answer_ = new ArrayList<Integer>();
        this.result_ = new ArrayList<Integer>();
        this.agenda_ = null;
        this.penalty_ = new ArrayList<List<Double>>();
        this.featureCache_ = new ArrayList<List<Integer>>();
    }

    public void clearNodes() {
        if (this.node_ != null && !this.node_.isEmpty()) {
            for (List<Node> n : this.node_) {
                for (int i = 0; i < n.size(); ++i) {
                    if (n.get(i) == null) continue;
                    n.get(i).clear();
                    n.set(i, null);
                }
            }
        }
    }

    @Override
    public void setPenalty(int i, int j, double penalty) {
        if (this.penalty_.isEmpty()) {
            for (int s = 0; s < this.node_.size(); ++s) {
                List<Double> penaltys = Arrays.asList(new Double[this.ysize_]);
                this.penalty_.add(penaltys);
            }
        }
        this.penalty_.get(i).set(j, penalty);
    }

    @Override
    public double penalty(int i, int j) {
        return this.penalty_.isEmpty() ? 0.0 : this.penalty_.get(i).get(j);
    }

    public void forwardbackward() {
        if (!this.x_.isEmpty()) {
            int j;
            int i;
            for (i = 0; i < this.x_.size(); ++i) {
                for (j = 0; j < this.ysize_; ++j) {
                    this.node_.get(i).get(j).calcAlpha();
                }
            }
            for (i = this.x_.size() - 1; i >= 0; --i) {
                for (j = 0; j < this.ysize_; ++j) {
                    this.node_.get(i).get(j).calcBeta();
                }
            }
            this.Z_ = 0.0;
            for (int j2 = 0; j2 < this.ysize_; ++j2) {
                this.Z_ = Node.logsumexp(this.Z_, this.node_.get((int)0).get((int)j2).beta, j2 == 0);
            }
        }
    }

    public void viterbi() {
        for (int i = 0; i < this.x_.size(); ++i) {
            for (int j = 0; j < this.ysize_; ++j) {
                double bestc = -1.0E37;
                Node best = null;
                List<Path> lpath = this.node_.get((int)i).get((int)j).lpath;
                for (Path p : lpath) {
                    double cost = p.lnode.bestCost + p.cost + this.node_.get((int)i).get((int)j).cost;
                    if (!(cost > bestc)) continue;
                    bestc = cost;
                    best = p.lnode;
                }
                this.node_.get((int)i).get((int)j).prev = best;
                this.node_.get((int)i).get((int)j).bestCost = best != null ? bestc : this.node_.get((int)i).get((int)j).cost;
            }
        }
        double bestc = -1.0E37;
        Node best = null;
        int s = this.x_.size() - 1;
        for (int j = 0; j < this.ysize_; ++j) {
            if (!(bestc < this.node_.get((int)s).get((int)j).bestCost)) continue;
            best = this.node_.get(s).get(j);
            bestc = this.node_.get((int)s).get((int)j).bestCost;
        }
        Node n = best;
        while (n != null) {
            this.result_.set(n.x, n.y);
            n = n.prev;
        }
        this.cost_ = -this.node_.get((int)(this.x_.size() - 1)).get((int)this.result_.get((int)(this.x_.size() - 1)).intValue()).bestCost;
    }

    public void buildLattice() {
        if (!this.x_.isEmpty()) {
            int j;
            int i;
            this.feature_index_.rebuildFeatures(this);
            for (i = 0; i < this.x_.size(); ++i) {
                for (j = 0; j < this.ysize_; ++j) {
                    this.feature_index_.calcCost(this.node_.get(i).get(j));
                    List<Path> lpath = this.node_.get((int)i).get((int)j).lpath;
                    for (Path p : lpath) {
                        this.feature_index_.calcCost(p);
                    }
                }
            }
            if (!this.penalty_.isEmpty()) {
                for (i = 0; i < this.x_.size(); ++i) {
                    for (j = 0; j < this.ysize_; ++j) {
                        this.node_.get((int)i).get((int)j).cost += this.penalty_.get(i).get(j).doubleValue();
                    }
                }
            }
        }
    }

    public boolean initNbest() {
        if (this.agenda_ == null) {
            this.agenda_ = new PriorityQueue<QueueElement>(10, new Comparator<QueueElement>(){

                @Override
                public int compare(QueueElement o1, QueueElement o2) {
                    return (int)(o1.fx - o2.fx);
                }
            });
        }
        this.agenda_.clear();
        int k = this.x_.size() - 1;
        for (int i = 0; i < this.ysize_; ++i) {
            QueueElement eos = new QueueElement();
            eos.node = this.node_.get(k).get(i);
            eos.fx = -this.node_.get((int)k).get((int)i).bestCost;
            eos.gx = -this.node_.get((int)k).get((int)i).cost;
            eos.next = null;
            this.agenda_.add(eos);
        }
        return true;
    }

    public Node node(int i, int j) {
        return this.node_.get(i).get(j);
    }

    public void set_node(Node n, int i, int j) {
        this.node_.get(i).set(j, n);
    }

    public int eval() {
        int err = 0;
        for (int i = 0; i < this.x_.size(); ++i) {
            if (this.answer_.get(i).equals(this.result_.get(i))) continue;
            ++err;
        }
        return err;
    }

    public double gradient(double[] expected) {
        int i;
        if (this.x_.isEmpty()) {
            return 0.0;
        }
        this.buildLattice();
        this.forwardbackward();
        double s = 0.0;
        for (i = 0; i < this.x_.size(); ++i) {
            for (int j = 0; j < this.ysize_; ++j) {
                this.node_.get(i).get(j).calcExpectation(expected, this.Z_, this.ysize_);
            }
        }
        block2: for (i = 0; i < this.x_.size(); ++i) {
            List<Integer> fvector = this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).fVector;
            int j = 0;
            while (fvector.get(j) != -1) {
                int idx;
                int n = idx = fvector.get(j) + this.answer_.get(i);
                expected[n] = expected[n] - 1.0;
                ++j;
            }
            s += this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).cost;
            List<Path> lpath = this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).lpath;
            for (Path p : lpath) {
                if (p.lnode.y != this.answer_.get(p.lnode.x)) continue;
                int k = 0;
                while (p.fvector.get(k) != -1) {
                    int idx;
                    int n = idx = p.fvector.get(k) + p.lnode.y * this.ysize_ + p.rnode.y;
                    expected[n] = expected[n] - 1.0;
                    ++k;
                }
                s += p.cost;
                continue block2;
            }
        }
        this.viterbi();
        return this.Z_ - s;
    }

    public double collins(List<Double> collins) {
        int i;
        if (this.x_.isEmpty()) {
            return 0.0;
        }
        this.buildLattice();
        this.viterbi();
        double s = 0.0;
        int num = 0;
        for (i = 0; i < this.x_.size(); ++i) {
            if (!this.answer_.get(i).equals(this.result_.get(i))) continue;
            ++num;
        }
        if (num == this.x_.size()) {
            return 0.0;
        }
        block1: for (i = 0; i < this.x_.size(); ++i) {
            s += this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).cost;
            List<Integer> fvector = this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).fVector;
            int k = 0;
            while (fvector.get(k) != -1) {
                int idx = fvector.get(k) + this.answer_.get(i);
                collins.set(idx, collins.get(idx) + 1.0);
                ++k;
            }
            List<Path> lpath = this.node_.get((int)i).get((int)this.answer_.get((int)i).intValue()).lpath;
            for (Path p : lpath) {
                if (p.lnode.y != this.answer_.get(p.lnode.x)) continue;
                int j = 0;
                while (p.fvector.get(j) != -1) {
                    int idx = p.fvector.get(j) + p.lnode.y * this.ysize_ + p.rnode.y;
                    collins.set(idx, collins.get(i) + 1.0);
                    ++j;
                }
                s += p.cost;
                break;
            }
            s -= this.node_.get((int)i).get((int)this.result_.get((int)i).intValue()).cost;
            List<Integer> fvectorR = this.node_.get((int)i).get((int)this.result_.get((int)i).intValue()).fVector;
            int k2 = 0;
            while (fvectorR.get(k2) != -1) {
                int idx = fvector.get(k2) + this.result_.get(i);
                collins.set(idx, collins.get(idx) - 1.0);
                ++k2;
            }
            List<Path> lpathR = this.node_.get((int)i).get((int)this.result_.get((int)i).intValue()).lpath;
            for (Path p : lpathR) {
                if (p.lnode.y != this.result_.get(p.lnode.x)) continue;
                int j = 0;
                while (p.fvector.get(j) != -1) {
                    int idx = p.fvector.get(j) + p.lnode.y * this.ysize_ + p.rnode.y;
                    collins.set(idx, collins.get(i) - 1.0);
                    ++j;
                }
                s -= p.cost;
                continue block1;
            }
        }
        return -s;
    }

    public boolean shrink() {
        if (!this.feature_index_.buildFeatures(this)) {
            System.err.println("build features failed");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadStatus read(BufferedReader br) {
        this.clear();
        ReadStatus status = ReadStatus.SUCCESS;
        try {
            String line;
            do {
                if ((line = br.readLine()) == null) {
                    return ReadStatus.EOF;
                }
                if (line.length() == 0) return status;
            } while (this.add(line));
            System.err.println("fail to add line: " + line);
            return ReadStatus.ERROR;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error reading stream");
            return ReadStatus.ERROR;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nbest_ < 1) {
            if (this.vlevel_ >= 1) {
                sb.append("# ");
                sb.append(this.prob());
                sb.append("\n");
            }
            for (int i = 0; i < this.x_.size(); ++i) {
                for (String s : this.x_.get(i)) {
                    sb.append(s);
                    sb.append("\t");
                }
                sb.append(this.yname(this.y(i)));
                if (this.vlevel_ >= 1) {
                    sb.append("/");
                    sb.append(this.prob(i));
                }
                if (this.vlevel_ >= 2) {
                    for (int j = 0; j < this.ysize_; ++j) {
                        sb.append("\t");
                        sb.append(this.yname(j));
                        sb.append("/");
                        sb.append(this.prob(i, j));
                    }
                }
                sb.append("\n");
            }
            sb.append("\n");
        } else {
            for (int n = 0; n < this.nbest_ && this.next(); ++n) {
                sb.append("# ").append(n).append(" ").append(this.prob()).append("\n");
                for (int i = 0; i < this.x_.size(); ++i) {
                    for (String s : this.x_.get(i)) {
                        sb.append(s).append('\t');
                    }
                    sb.append(this.yname(this.y(i)));
                    if (this.vlevel_ >= 1) {
                        sb.append('/').append(this.prob(i));
                    }
                    if (this.vlevel_ >= 2) {
                        for (int j = 0; j < this.ysize_; ++j) {
                            sb.append('\t').append(this.yname(j)).append('/').append(this.prob(i, j));
                        }
                    }
                    sb.append('\n');
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public boolean open(FeatureIndex featureIndex) {
        this.mode_ = Mode.LEARN;
        this.feature_index_ = featureIndex;
        this.ysize_ = this.feature_index_.ysize();
        return true;
    }

    @Override
    public boolean open(String filename) {
        return true;
    }

    public boolean setModel(ModelImpl model) {
        this.mode_ = Mode.TEST;
        this.feature_index_ = model.getFeatureIndex_();
        this.nbest_ = model.getNbest_();
        this.vlevel_ = model.getVlevel_();
        this.ysize_ = this.feature_index_.ysize();
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean add(String line) {
        String[] cols = line.split("[\t ]", -1);
        return this.add(cols);
    }

    @Override
    public boolean add(String[] cols) {
        int xsize = this.feature_index_.getXsize_();
        if (this.mode_ == Mode.LEARN && cols.length < xsize + 1 || this.mode_ == Mode.TEST && cols.length < xsize) {
            System.err.println("# x is small: size=" + cols.length + " xsize=" + xsize);
            return false;
        }
        this.x_.add(Arrays.asList(cols));
        this.result_.add(0);
        int tmpAnswer = 0;
        if (this.mode_ == Mode.LEARN) {
            int r = this.ysize_;
            for (int i = 0; i < this.ysize_; ++i) {
                if (!cols[xsize].equals(this.yname(i))) continue;
                r = i;
            }
            if (r == this.ysize_) {
                System.err.println("cannot find answer");
                return false;
            }
            tmpAnswer = r;
        }
        this.answer_.add(tmpAnswer);
        List<Node> l = Arrays.asList(new Node[this.ysize_]);
        this.node_.add(l);
        return true;
    }

    public List<List<Integer>> getFeatureCache_() {
        return this.featureCache_;
    }

    public void setFeatureCache_(List<List<Integer>> featureCache_) {
        this.featureCache_ = featureCache_;
    }

    @Override
    public int size() {
        return this.x_.size();
    }

    @Override
    public int xsize() {
        return this.feature_index_.getXsize_();
    }

    @Override
    public int dsize() {
        return this.feature_index_.size();
    }

    @Override
    public float[] weightVector() {
        return this.feature_index_.getAlphaFloat_();
    }

    @Override
    public boolean empty() {
        return this.x_.isEmpty();
    }

    @Override
    public double prob() {
        return Math.exp(-this.cost_ - this.Z_);
    }

    @Override
    public double prob(int i, int j) {
        return TaggerImpl.toProb(this.node_.get(i).get(j), this.Z_);
    }

    @Override
    public double prob(int i) {
        return TaggerImpl.toProb(this.node_.get(i).get(this.result_.get(i)), this.Z_);
    }

    @Override
    public double alpha(int i, int j) {
        return this.node_.get((int)i).get((int)j).alpha;
    }

    @Override
    public double beta(int i, int j) {
        return this.node_.get((int)i).get((int)j).beta;
    }

    @Override
    public double emissionCost(int i, int j) {
        return this.node_.get((int)i).get((int)j).cost;
    }

    @Override
    public double nextTransitionCost(int i, int j, int k) {
        return this.node_.get((int)i).get((int)j).rpath.get((int)k).cost;
    }

    @Override
    public double prevTransitionCost(int i, int j, int k) {
        return this.node_.get((int)i).get((int)j).lpath.get((int)k).cost;
    }

    @Override
    public double bestCost(int i, int j) {
        return this.node_.get((int)i).get((int)j).bestCost;
    }

    @Override
    public List<Integer> emissionVector(int i, int j) {
        return this.node_.get((int)i).get((int)j).fVector;
    }

    @Override
    public List<Integer> nextTransitionVector(int i, int j, int k) {
        return this.node_.get((int)i).get((int)j).rpath.get((int)k).fvector;
    }

    @Override
    public List<Integer> prevTransitionVector(int i, int j, int k) {
        return this.node_.get((int)i).get((int)j).lpath.get((int)k).fvector;
    }

    @Override
    public int answer(int i) {
        return this.answer_.get(i);
    }

    @Override
    public int result(int i) {
        return this.result_.get(i);
    }

    @Override
    public int y(int i) {
        return this.result_.get(i);
    }

    @Override
    public String yname(int i) {
        return this.feature_index_.getY_().get(i);
    }

    @Override
    public String y2(int i) {
        return this.yname(this.result_.get(i));
    }

    @Override
    public String x(int i, int j) {
        return this.x_.get(i).get(j);
    }

    public List<String> x(int i) {
        return this.x_.get(i);
    }

    @Override
    public String parse(String s) {
        return "";
    }

    @Override
    public String parse(String s, int i) {
        return "";
    }

    @Override
    public String parse(String s, int i, String s2, int j) {
        return "";
    }

    @Override
    public boolean parse() {
        if (!this.feature_index_.buildFeatures(this)) {
            System.err.println("fail to build featureIndex");
            return false;
        }
        if (this.x_.isEmpty()) {
            return true;
        }
        this.buildLattice();
        if (this.nbest_ != 0 || this.vlevel_ >= 1) {
            this.forwardbackward();
        }
        this.viterbi();
        if (this.nbest_ != 0) {
            this.initNbest();
        }
        return true;
    }

    @Override
    public boolean clear() {
        if (this.mode_ == Mode.TEST) {
            this.feature_index_.clear();
        }
        this.lastError = null;
        this.x_.clear();
        this.node_.clear();
        this.answer_.clear();
        this.result_.clear();
        this.featureCache_.clear();
        this.cost_ = 0.0;
        this.Z_ = 0.0;
        return true;
    }

    @Override
    public boolean next() {
        while (!this.agenda_.isEmpty()) {
            QueueElement top = this.agenda_.peek();
            Node rnode = top.node;
            this.agenda_.remove(top);
            if (rnode.x == 0) {
                QueueElement n = top;
                while (n != null) {
                    this.result_.set(n.node.x, n.node.y);
                    n = n.next;
                }
                this.cost_ = top.gx;
                return true;
            }
            for (Path p : rnode.lpath) {
                QueueElement n = new QueueElement();
                n.node = p.lnode;
                n.gx = -p.lnode.cost - p.cost + top.gx;
                n.fx = -p.lnode.bestCost - p.cost + top.gx;
                n.next = top;
                this.agenda_.add(n);
            }
        }
        return false;
    }

    public float costFactor() {
        return (float)this.feature_index_.getCostFactor_();
    }

    void setCostFactor(float cost_factor) {
        if (cost_factor > 0.0f) {
            this.feature_index_.setCostFactor_(cost_factor);
        }
    }

    void setNbest(int nbest) {
        this.nbest_ = nbest;
    }

    private static double toProb(Node n, double Z) {
        return Math.exp(n.alpha + n.beta - n.cost - Z);
    }

    @Override
    public boolean open(FeatureIndex featureIndex, int nbest, int vlevel) {
        return this.open(featureIndex, nbest, vlevel, 1.0);
    }

    @Override
    public boolean open(FeatureIndex featureIndex, int nbest, int vlevel, double costFactor) {
        if (costFactor <= 0.0) {
            System.err.println("cost factor must be positive");
            return false;
        }
        this.nbest_ = nbest;
        this.vlevel_ = vlevel;
        this.feature_index_ = featureIndex;
        this.feature_index_.setCostFactor_(costFactor);
        this.ysize_ = this.feature_index_.ysize();
        return true;
    }

    public boolean open(InputStream stream, int nbest, int vlevel, double costFactor) {
        if (costFactor <= 0.0) {
            System.err.println("cost factor must be positive");
            return false;
        }
        this.feature_index_ = new DecoderFeatureIndex();
        if (!this.feature_index_.open(stream)) {
            System.err.println("Failed to open model file ");
            return false;
        }
        this.nbest_ = nbest;
        this.vlevel_ = vlevel;
        this.feature_index_.setCostFactor_(costFactor);
        this.ysize_ = this.feature_index_.ysize();
        return true;
    }

    public Mode getMode_() {
        return this.mode_;
    }

    public void setMode_(Mode mode_) {
        this.mode_ = mode_;
    }

    public int getVlevel_() {
        return this.vlevel_;
    }

    public void setVlevel_(int vlevel_) {
        this.vlevel_ = vlevel_;
    }

    public int getNbest_() {
        return this.nbest_;
    }

    public void setNbest_(int nbest_) {
        this.nbest_ = nbest_;
    }

    public int getYsize_() {
        return this.ysize_;
    }

    public void setYsize_(int ysize_) {
        this.ysize_ = ysize_;
    }

    public double getCost_() {
        return this.cost_;
    }

    public void setCost_(double cost_) {
        this.cost_ = cost_;
    }

    public double getZ_() {
        return this.Z_;
    }

    public void setZ_(double z_) {
        this.Z_ = z_;
    }

    public int getFeature_id_() {
        return this.feature_id_;
    }

    public void setFeature_id_(int feature_id_) {
        this.feature_id_ = feature_id_;
    }

    public int getThread_id_() {
        return this.thread_id_;
    }

    public void setThread_id_(int thread_id_) {
        this.thread_id_ = thread_id_;
    }

    public FeatureIndex getFeature_index_() {
        return this.feature_index_;
    }

    public void setFeature_index_(FeatureIndex feature_index_) {
        this.feature_index_ = feature_index_;
    }

    public List<List<String>> getX_() {
        return this.x_;
    }

    public void setX_(List<List<String>> x_) {
        this.x_ = x_;
    }

    public List<List<Node>> getNode_() {
        return this.node_;
    }

    public void setNode_(List<List<Node>> node_) {
        this.node_ = node_;
    }

    public List<Integer> getAnswer_() {
        return this.answer_;
    }

    public void setAnswer_(List<Integer> answer_) {
        this.answer_ = answer_;
    }

    public List<Integer> getResult_() {
        return this.result_;
    }

    public void setResult_(List<Integer> result_) {
        this.result_ = result_;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            return;
        }
        TaggerImpl tagger = new TaggerImpl(Mode.TEST);
        InputStream stream = null;
        try {
            stream = IOUtil.newInputStream(args[0]);
        }
        catch (IOException e) {
            System.err.printf("model not exits for %s", args[0]);
            return;
        }
        if (stream != null && !tagger.open(stream, 2, 0, 1.0)) {
            System.err.println("open error");
            return;
        }
        System.out.println("Done reading model");
        if (args.length >= 2) {
            InputStream fis = IOUtil.newInputStream(args[1]);
            InputStreamReader isr = new InputStreamReader(fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            while (true) {
                ReadStatus status;
                if (ReadStatus.ERROR == (status = tagger.read(br))) {
                    System.err.println("read error");
                    return;
                }
                if (ReadStatus.EOF == status || tagger.getX_().isEmpty()) break;
                if (!tagger.parse()) {
                    System.err.println("parse error");
                    return;
                }
                System.out.print(tagger.toString());
            }
            br.close();
        }
    }

    public static enum ReadStatus {
        SUCCESS,
        EOF,
        ERROR;

    }

    public static enum Mode {
        TEST,
        LEARN;

    }

    class QueueElement {
        Node node;
        QueueElement next;
        double fx;
        double gx;

        QueueElement() {
        }
    }
}

