/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.BasicObsCredentialsProvider;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.AuthTypeEnum;

public class ProviderCredentials {
    protected static final ILogger log = LoggerBuilder.getLogger(ProviderCredentials.class);
    protected AuthTypeEnum authType;
    private static ThreadLocal<AuthTypeEnum> threadLocalAuthType;
    private IObsCredentialsProvider obsCredentialsProvider;
    private boolean isAuthTypeNegotiation;

    public String getRegion() {
        return "region";
    }

    public ProviderCredentials(String accessKey, String secretKey) {
        this.setObsCredentialsProvider(new BasicObsCredentialsProvider(accessKey, secretKey));
    }

    public ProviderCredentials(String accessKey, String secretKey, String securityToken) {
        this.setObsCredentialsProvider(new BasicObsCredentialsProvider(accessKey, secretKey, securityToken));
    }

    public AuthTypeEnum getAuthType() {
        if (!this.isAuthTypeNegotiation) {
            return this.authType;
        }
        return threadLocalAuthType == null ? this.authType : threadLocalAuthType.get();
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public void setIsAuthTypeNegotiation(boolean isAuthTypeNegotiation) {
        this.isAuthTypeNegotiation = isAuthTypeNegotiation;
    }

    public boolean getIsAuthTypeNegotiation() {
        return this.isAuthTypeNegotiation;
    }

    public void setObsCredentialsProvider(IObsCredentialsProvider obsCredentialsProvider) {
        this.obsCredentialsProvider = obsCredentialsProvider;
    }

    public IObsCredentialsProvider getObsCredentialsProvider() {
        return this.obsCredentialsProvider;
    }

    public BasicSecurityKey getSecurityKey() {
        return (BasicSecurityKey)this.obsCredentialsProvider.getSecurityKey();
    }

    public void setThreadLocalAuthType(AuthTypeEnum authType) {
        if (threadLocalAuthType != null) {
            threadLocalAuthType.set(authType);
        }
    }

    public void removeThreadLocalAuthType() {
        if (threadLocalAuthType != null) {
            threadLocalAuthType.remove();
        }
    }

    public void initThreadLocalAuthType() {
        if (threadLocalAuthType == null) {
            threadLocalAuthType = new ThreadLocal<AuthTypeEnum>(){

                @Override
                protected AuthTypeEnum initialValue() {
                    return ProviderCredentials.this.authType;
                }
            };
        }
    }
}

