/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.Callback;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.PutObjectBasicRequest;

public class UploadFileRequest
extends PutObjectBasicRequest {
    private long partSize = 0x900000L;
    private int taskNum = 1;
    private String uploadFile;
    private boolean enableCheckpoint = false;
    private String checkpointFile;
    private ObjectMetadata objectMetadata;
    private boolean enableCheckSum = false;
    private ProgressListener progressListener;
    private String encodingType;
    private Callback callback;
    private long progressInterval = 102400L;
    private boolean needAbortUploadFileAfterCancel = false;
    private boolean needCalculateCRC64 = false;
    private boolean needStreamCalculateCRC64 = false;

    public UploadFileRequest(String bucketName, String objectKey) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.uploadFile = uploadFile;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, String encodingType) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.uploadFile = uploadFile;
        this.encodingType = encodingType;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, long partSize) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.uploadFile = uploadFile;
        this.partSize = partSize;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, long partSize, int taskNum) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.uploadFile = uploadFile;
        this.partSize = partSize;
        this.taskNum = taskNum;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, long partSize, int taskNum, boolean enableCheckpoint) {
        this(bucketName, objectKey, uploadFile, partSize, taskNum, enableCheckpoint, null);
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, long partSize, int taskNum, boolean enableCheckpoint, String checkpointFile) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.partSize = partSize;
        this.taskNum = taskNum;
        this.uploadFile = uploadFile;
        this.enableCheckpoint = enableCheckpoint;
        this.checkpointFile = checkpointFile;
    }

    public UploadFileRequest(String bucketName, String objectKey, String uploadFile, long partSize, int taskNum, boolean enableCheckpoint, String checkpointFile, boolean enableCheckSum) {
        this(bucketName, objectKey, uploadFile, partSize, taskNum, enableCheckpoint, checkpointFile);
        this.enableCheckSum = enableCheckSum;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize < 102400L ? 102400L : Math.min(partSize, 0x140000000L);
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum < 1 ? 1 : Math.min(taskNum, 1000);
    }

    public String getUploadFile() {
        return this.uploadFile;
    }

    public void setUploadFile(String uploadFile) {
        this.uploadFile = uploadFile;
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public void setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }

    public void setCheckpointFile(String checkpointFile) {
        this.checkpointFile = checkpointFile;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public boolean isEnableCheckSum() {
        return this.enableCheckSum;
    }

    public void setEnableCheckSum(boolean enableCheckSum) {
        this.enableCheckSum = enableCheckSum;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public long getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(long progressInterval) {
        this.progressInterval = progressInterval;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public boolean isNeedAbortUploadFileAfterCancel() {
        return this.needAbortUploadFileAfterCancel;
    }

    public void setNeedAbortUploadFileAfterCancel(boolean needAbortUploadFileAfterCancel) {
        this.needAbortUploadFileAfterCancel = needAbortUploadFileAfterCancel;
    }

    public boolean isNeedCalculateCRC64() {
        return this.needCalculateCRC64;
    }

    public void setNeedCalculateCRC64(boolean needCalculateCRC64) {
        this.needCalculateCRC64 = needCalculateCRC64;
    }

    public boolean isNeedStreamCalculateCRC64() {
        return this.needStreamCalculateCRC64;
    }

    public void setNeedStreamCalculateCRC64(boolean needStreamCalculateCRC64) {
        this.needStreamCalculateCRC64 = needStreamCalculateCRC64;
    }

    @Override
    public String toString() {
        return "UploadFileRequest [bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ", partSize=" + this.partSize + ", taskNum=" + this.taskNum + ", uploadFile=" + this.uploadFile + ", enableCheckpoint=" + this.enableCheckpoint + ", checkpointFile=" + this.checkpointFile + ", objectMetadata=" + this.objectMetadata + ", isEncodeHeaders=" + this.encodeHeaders + ", enableCheckSum=" + this.enableCheckSum + ", encodingType=" + this.encodingType + "]";
    }
}

