/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.disovery;

import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import com.huaweicloud.common.transport.TransportUtils;
import com.huaweicloud.common.util.URLUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.service.center.client.AddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterUtils.class);

    public static AddressManager createAddressManager(DiscoveryBootstrapProperties discoveryProperties) {
        List<String> addresses = URLUtil.getEnvServerURL();
        if (addresses.isEmpty()) {
            addresses = URLUtil.dealMultiUrl(discoveryProperties.getAddress());
        }
        LOGGER.info("initialize discovery server={}", (Object)addresses.toString());
        return new AddressManager("default", addresses);
    }

    public static ServiceCenterClient serviceCenterClient(DiscoveryBootstrapProperties discoveryProperties, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders) {
        AddressManager addressManager = ServiceCenterUtils.createAddressManager(discoveryProperties);
        HttpConfiguration.SSLProperties sslProperties = TransportUtils.createSSLProperties(addressManager.sslEnabled(), serviceCombSSLProperties);
        return new ServiceCenterClient(addressManager, sslProperties, ServiceCenterUtils.getRequestAuthHeaderProvider(authHeaderProviders), "default", new HashMap()).setEventBus(EventManager.getEventBus());
    }

    public static ServiceCenterWatch serviceCenterWatch(DiscoveryBootstrapProperties discoveryProperties, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders) {
        AddressManager addressManager = ServiceCenterUtils.createAddressManager(discoveryProperties);
        HttpConfiguration.SSLProperties sslProperties = TransportUtils.createSSLProperties(addressManager.sslEnabled(), serviceCombSSLProperties);
        return new ServiceCenterWatch(addressManager, sslProperties, ServiceCenterUtils.getRequestAuthHeaderProvider(authHeaderProviders), "default", new HashMap(), EventManager.getEventBus());
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }
}

